/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import java.io.Serializable;

public class IntrinsicParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public int width;
    public int height;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;
    public double[] radial;
    public double t1;
    public double t2;

    public IntrinsicParameters() {
    }

    public IntrinsicParameters(IntrinsicParameters param) {
        this.set(param);
    }

    public IntrinsicParameters(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public IntrinsicParameters fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.width = width;
        this.height = height;
        return this;
    }

    public IntrinsicParameters fsetRadial(double ... radial) {
        this.radial = (double[])radial.clone();
        return this;
    }

    public IntrinsicParameters fsetTangental(double t1, double t2) {
        this.t1 = t1;
        this.t2 = t2;
        return this;
    }

    public void set(IntrinsicParameters param) {
        this.fx = param.fx;
        this.fy = param.fy;
        this.skew = param.skew;
        this.cx = param.cx;
        this.cy = param.cy;
        this.width = param.width;
        this.height = param.height;
        this.radial = param.radial;
        if (param.radial != null) {
            this.radial = (double[])param.radial.clone();
        }
        this.t1 = param.t1;
        this.t2 = param.t2;
    }

    public boolean isDistorted() {
        if (this.radial != null && this.radial.length > 0) {
            for (int i = 0; i < this.radial.length; ++i) {
                if (this.radial[i] == 0.0) continue;
                return true;
            }
        }
        return this.t1 != 0.0 || this.t2 != 0.0;
    }

    public double getCx() {
        return this.cx;
    }

    public void setCx(double cx) {
        this.cx = cx;
    }

    public double getCy() {
        return this.cy;
    }

    public void setCy(double cy) {
        this.cy = cy;
    }

    public double getFx() {
        return this.fx;
    }

    public void setFx(double fx) {
        this.fx = fx;
    }

    public double getFy() {
        return this.fy;
    }

    public void setFy(double fy) {
        this.fy = fy;
    }

    public double[] getRadial() {
        return this.radial;
    }

    public void setRadial(double[] radial) {
        this.radial = radial;
    }

    public double getSkew() {
        return this.skew;
    }

    public void setSkew(double skew) {
        this.skew = skew;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getT1() {
        return this.t1;
    }

    public void setT1(double t1) {
        this.t1 = t1;
    }

    public double getT2() {
        return this.t2;
    }

    public void setT2(double t2) {
        this.t2 = t2;
    }

    public void print() {
        System.out.println("Shape " + this.width + " " + this.height);
        System.out.printf("center %7.2f %7.2f\n", this.cx, this.cy);
        System.out.println("fx = " + this.fx);
        System.out.println("fy = " + this.fy);
        System.out.println("skew = " + this.skew);
        if (this.radial != null) {
            for (int i = 0; i < this.radial.length; ++i) {
                System.out.printf("radial[%d] = %6.2e\n", i, this.radial[i]);
            }
        } else {
            System.out.println("No radial");
        }
        if (this.t1 != 0.0 && this.t2 != 0.0) {
            System.out.printf("tangential = ( %6.2e , %6.2e)\n", this.t1, this.t2);
        } else {
            System.out.println("No tangential");
        }
    }
}

