/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.ddogleg.struct.GrowQueue_I8;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

public class UtilImageIO {
    public static BufferedImage loadImage(String fileName) {
        BufferedImage img;
        try {
            img = ImageIO.read(new File(fileName));
            if (img == null) {
                if (fileName.endsWith("ppm") || fileName.endsWith("PPM")) {
                    return UtilImageIO.loadPPM(fileName, null);
                }
                if (fileName.endsWith("pgm") || fileName.endsWith("PGM")) {
                    return UtilImageIO.loadPGM(fileName, null);
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return img;
    }

    public static BufferedImage loadImage(String directory, String fileName) {
        return UtilImageIO.loadImage(new File(directory, fileName).getPath());
    }

    public static List<BufferedImage> loadImages(String directory, final String regex) {
        File[] files = new File(directory).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regex);
            }
        });
        ArrayList<BufferedImage> ret = new ArrayList<BufferedImage>();
        for (File f : files) {
            BufferedImage img = UtilImageIO.loadImage(f.getAbsolutePath());
            if (img == null) continue;
            ret.add(img);
        }
        return ret;
    }

    public static BufferedImage loadImage(URL fileName) {
        BufferedImage img;
        try {
            img = ImageIO.read(fileName);
        }
        catch (IOException e) {
            return null;
        }
        return img;
    }

    public static <T extends ImageGray> T loadImage(String fileName, Class<T> imageType) {
        BufferedImage img = UtilImageIO.loadImage(fileName);
        if (img == null) {
            return null;
        }
        return (T)ConvertBufferedImage.convertFromSingle(img, null, imageType);
    }

    public static <T extends ImageGray> T loadImage(String directory, String fileName, Class<T> imageType) {
        return UtilImageIO.loadImage(new File(directory, fileName).getPath(), imageType);
    }

    public static <T extends ImageBase> T loadImage(File image, boolean orderRgb, ImageType<T> imageType) {
        BufferedImage img = UtilImageIO.loadImage(image.getAbsolutePath());
        if (img == null) {
            return null;
        }
        T output = imageType.createImage(img.getWidth(), img.getHeight());
        ConvertBufferedImage.convertFrom(img, orderRgb, output);
        return output;
    }

    public static void saveImage(BufferedImage img, String fileName) {
        block4: {
            try {
                String[] a = fileName.split("[.]");
                String type = a.length > 0 ? a[a.length - 1] : "jpg";
                if (ImageIO.write((RenderedImage)img, type, new File(fileName))) break block4;
                if (fileName.endsWith("ppm") || fileName.endsWith("PPM")) {
                    Planar<GrayU8> color = ConvertBufferedImage.convertFromMulti(img, null, true, GrayU8.class);
                    UtilImageIO.savePPM(color, fileName, null);
                    break block4;
                }
                if (fileName.endsWith("pgm") || fileName.endsWith("PGM")) {
                    GrayU8 gray = ConvertBufferedImage.convertFrom(img, (GrayU8)null);
                    UtilImageIO.savePGM(gray, fileName);
                    break block4;
                }
                throw new IllegalArgumentException("No writer appropriate found");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void saveImage(ImageBase image, String fileName) {
        BufferedImage out = ConvertBufferedImage.convertTo(image, null, true);
        UtilImageIO.saveImage(out, fileName);
    }

    public static BufferedImage loadPPM(String fileName, BufferedImage storage) throws IOException {
        return UtilImageIO.loadPPM(new FileInputStream(fileName), storage);
    }

    public static BufferedImage loadPGM(String fileName, BufferedImage storage) throws IOException {
        return UtilImageIO.loadPGM(new FileInputStream(fileName), storage);
    }

    public static BufferedImage loadPPM(InputStream inputStream, BufferedImage storage) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        UtilImageIO.readLine(in);
        String line = UtilImageIO.readLine(in);
        while (line.charAt(0) == '#') {
            line = UtilImageIO.readLine(in);
        }
        String[] s = line.split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null || storage.getWidth() != w || storage.getHeight() != h) {
            storage = new BufferedImage(w, h, 1);
        }
        int length = w * h * 3;
        byte[] data = new byte[length];
        in.read(data, 0, length);
        boolean useFailSafe = storage.getType() != 1;
        try {
            int[] rgb = ((IntegerInterleavedRaster)storage.getRaster()).getDataStorage();
            int indexIn = 0;
            int indexOut = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    rgb[indexOut++] = (data[indexIn++] & 0xFF) << 16 | (data[indexIn++] & 0xFF) << 8 | data[indexIn++] & 0xFF;
                }
            }
        }
        catch (AccessControlException e) {
            useFailSafe = true;
        }
        if (useFailSafe) {
            int indexIn = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    storage.setRGB(x, y, (data[indexIn++] & 0xFF) << 16 | (data[indexIn++] & 0xFF) << 8 | data[indexIn++] & 0xFF);
                }
            }
        }
        return storage;
    }

    public static BufferedImage loadPGM(InputStream inputStream, BufferedImage storage) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        UtilImageIO.readLine(in);
        String line = UtilImageIO.readLine(in);
        while (line.charAt(0) == '#') {
            line = UtilImageIO.readLine(in);
        }
        String[] s = line.split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null || storage.getWidth() != w || storage.getHeight() != h) {
            storage = new BufferedImage(w, h, 10);
        }
        int length = w * h;
        byte[] data = new byte[length];
        in.read(data, 0, length);
        boolean useFailSafe = storage.getType() != 10;
        try {
            byte[] gray = ((ByteInterleavedRaster)storage.getRaster()).getDataStorage();
            int indexIn = 0;
            int indexOut = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    gray[indexOut++] = data[indexIn++];
                }
            }
        }
        catch (AccessControlException e) {
            useFailSafe = true;
        }
        if (useFailSafe) {
            int indexIn = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int gray = data[indexIn++] & 0xFF;
                    storage.setRGB(x, y, gray << 16 | gray << 8 | gray);
                }
            }
        }
        return storage;
    }

    public static Planar<GrayU8> loadPPM_U8(String fileName, Planar<GrayU8> storage, GrowQueue_I8 temp) throws IOException {
        return UtilImageIO.loadPPM_U8(new FileInputStream(fileName), storage, temp);
    }

    public static Planar<GrayU8> loadPPM_U8(InputStream inputStream, Planar<GrayU8> storage, GrowQueue_I8 temp) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        UtilImageIO.readLine(in);
        String line = UtilImageIO.readLine(in);
        while (line.charAt(0) == '#') {
            line = UtilImageIO.readLine(in);
        }
        String[] s = line.split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null || storage.getNumBands() != 3) {
            storage = new Planar<GrayU8>(GrayU8.class, w, h, 3);
        } else {
            storage.reshape(w, h);
        }
        int length = w * h * 3;
        if (temp == null) {
            temp = new GrowQueue_I8(length);
        }
        temp.resize(length);
        byte[] data = temp.data;
        in.read(data, 0, length);
        GrayU8 band0 = storage.getBand(0);
        GrayU8 band1 = storage.getBand(1);
        GrayU8 band2 = storage.getBand(2);
        int indexIn = 0;
        for (int y = 0; y < storage.height; ++y) {
            int indexOut = storage.startIndex + y * storage.stride;
            int x = 0;
            while (x < storage.width) {
                band0.data[indexOut] = data[indexIn++];
                band1.data[indexOut] = data[indexIn++];
                band2.data[indexOut] = data[indexIn++];
                ++x;
                ++indexOut;
            }
        }
        return storage;
    }

    public static GrayU8 loadPGM_U8(String fileName, GrayU8 storage) throws IOException {
        return UtilImageIO.loadPGM_U8(new FileInputStream(fileName), storage);
    }

    public static GrayU8 loadPGM_U8(InputStream inputStream, GrayU8 storage) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        UtilImageIO.readLine(in);
        String line = UtilImageIO.readLine(in);
        while (line.charAt(0) == '#') {
            line = UtilImageIO.readLine(in);
        }
        String[] s = line.split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        UtilImageIO.readLine(in);
        if (storage == null) {
            storage = new GrayU8(w, h);
        }
        in.read(storage.data, 0, w * h);
        return storage;
    }

    public static void savePPM(Planar<GrayU8> rgb, String fileName, GrowQueue_I8 temp) throws IOException {
        File out = new File(fileName);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(out));
        String header = String.format("P6\n%d %d\n255\n", rgb.width, rgb.height);
        os.write(header.getBytes());
        if (temp == null) {
            temp = new GrowQueue_I8();
        }
        temp.resize(rgb.width * rgb.height * 3);
        byte[] data = temp.data;
        GrayU8 band0 = rgb.getBand(0);
        GrayU8 band1 = rgb.getBand(1);
        GrayU8 band2 = rgb.getBand(2);
        int indexOut = 0;
        for (int y = 0; y < rgb.height; ++y) {
            int index = rgb.startIndex + y * rgb.stride;
            int x = 0;
            while (x < rgb.width) {
                data[indexOut++] = band0.data[index];
                data[indexOut++] = band1.data[index];
                data[indexOut++] = band2.data[index];
                ++x;
                ++index;
            }
        }
        os.write(data, 0, temp.size);
        os.close();
    }

    public static void savePGM(GrayU8 gray, String fileName) throws IOException {
        File out = new File(fileName);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(out));
        String header = String.format("P5\n%d %d\n255\n", gray.width, gray.height);
        os.write(header.getBytes());
        os.write(gray.data, 0, gray.width * gray.height);
        os.close();
    }

    private static String readLine(DataInputStream in) throws IOException {
        String s = "";
        int b;
        while ((b = in.read()) != 10) {
            s = s + (char)b;
        }
        return s;
    }
}

