/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.tracking;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;

public class ExamplePointFeatureTracker<T extends ImageGray, D extends ImageGray> {
    Class<T> imageType;
    Class<D> derivType;
    PointTracker<T> tracker;
    ImagePanel gui = new ImagePanel();
    int pause;

    public ExamplePointFeatureTracker(Class<T> imageType, int pause) {
        this.imageType = imageType;
        this.derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.pause = pause;
    }

    public void process(SimpleImageSequence<T> sequence) {
        ImageGray frame = (ImageGray)sequence.next();
        this.gui.setPreferredSize(new Dimension(frame.getWidth(), frame.getHeight()));
        ShowImages.showWindow(this.gui, "KTL Tracker", true);
        while (sequence.hasNext()) {
            frame = (ImageGray)sequence.next();
            this.tracker.process(frame);
            if (this.tracker.getActiveTracks(null).size() < 130) {
                this.tracker.spawnTracks();
            }
            this.updateGUI(sequence);
            BoofMiscOps.pause(this.pause);
        }
    }

    private void updateGUI(SimpleImageSequence<T> sequence) {
        BufferedImage orig = (BufferedImage)sequence.getGuiImage();
        Graphics2D g2 = orig.createGraphics();
        for (PointTrack p : this.tracker.getActiveTracks(null)) {
            int red = (int)(2.5 * (double)(p.featureId % 100L));
            int green = (int)(1.7 * (double)(p.featureId % 150L));
            int blue = (int)(p.featureId % 255L);
            VisualizeFeatures.drawPoint(g2, (int)p.x, (int)p.y, new Color(red, green, blue));
        }
        for (PointTrack p : this.tracker.getNewTracks(null)) {
            VisualizeFeatures.drawPoint(g2, (int)p.x, (int)p.y, Color.green);
        }
        this.gui.setBufferedImage(orig);
        this.gui.repaint();
    }

    public void createKLT() {
        PkltConfig config = new PkltConfig();
        config.templateRadius = 3;
        config.pyramidScaling = new int[]{1, 2, 4, 8};
        this.tracker = FactoryPointTracker.klt(config, new ConfigGeneralDetector(600, 6, 1.0f), this.imageType, this.derivType);
    }

    public void createSURF() {
        ConfigFastHessian configDetector = new ConfigFastHessian();
        configDetector.maxFeaturesPerScale = 250;
        configDetector.extractRadius = 3;
        configDetector.initialSampleSize = 2;
        this.tracker = FactoryPointTracker.dda_FH_SURF_Fast(configDetector, null, null, this.imageType);
    }

    public static void main(String[] args) throws FileNotFoundException {
        Class<GrayF32> imageType = GrayF32.class;
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        SimpleImageSequence<GrayF32> sequence = media.openVideo(UtilIO.pathExample("zoom.mjpeg"), ImageType.single(imageType));
        int pause = 100;
        sequence.setLoop(true);
        ExamplePointFeatureTracker app = new ExamplePointFeatureTracker(imageType, pause);
        app.createKLT();
        app.process(sequence);
    }
}

