/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.abst.distort.FDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.examples.stereo.ExampleStereoDisparity;
import boofcv.gui.d3.PointCloudViewer;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.ejml.data.DenseMatrix64F;

public class ExampleStereoDisparity3D {
    public static final double scale = 0.5;
    public static final int minDisparity = 0;
    public static final int maxDisparity = 40;
    public static final int rangeDisparity = 40;

    public static void main(String[] args) {
        String calibDir = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        String imageDir = UtilIO.pathExample("stereo/");
        StereoParameters param = (StereoParameters)UtilIO.loadXML(calibDir, "stereo.xml");
        BufferedImage origLeft = UtilImageIO.loadImage(imageDir, "chair01_left.jpg");
        BufferedImage origRight = UtilImageIO.loadImage(imageDir, "chair01_right.jpg");
        GrayU8 distLeft = ConvertBufferedImage.convertFrom(origLeft, (GrayU8)null);
        GrayU8 distRight = ConvertBufferedImage.convertFrom(origRight, (GrayU8)null);
        GrayU8 scaledLeft = new GrayU8((int)((double)distLeft.width * 0.5), (int)((double)distLeft.height * 0.5));
        GrayU8 scaledRight = new GrayU8((int)((double)distRight.width * 0.5), (int)((double)distRight.height * 0.5));
        new FDistort(distLeft, scaledLeft).scaleExt().apply();
        new FDistort(distRight, scaledRight).scaleExt().apply();
        PerspectiveOps.scaleIntrinsic(param.left, 0.5);
        PerspectiveOps.scaleIntrinsic(param.right, 0.5);
        GrayU8 rectLeft = new GrayU8(scaledLeft.width, scaledLeft.height);
        GrayU8 rectRight = new GrayU8(scaledRight.width, scaledRight.height);
        RectifyCalibrated rectAlg = ExampleStereoDisparity.rectify(scaledLeft, scaledRight, param, rectLeft, rectRight);
        GrayF32 disparity = ExampleStereoDisparity.denseDisparitySubpixel(rectLeft, rectRight, 3, 0, 40);
        DenseMatrix64F rectK = rectAlg.getCalibrationMatrix();
        DenseMatrix64F rectR = rectAlg.getRectifiedRotation();
        PointCloudViewer viewer = new PointCloudViewer(rectK, 10.0);
        viewer.setPreferredSize(new Dimension(rectLeft.width, rectLeft.height));
        double baseline = param.getBaseline();
        double fx = rectK.get(0, 0);
        double fy = rectK.get(1, 1);
        double cx = rectK.get(0, 2);
        double cy = rectK.get(1, 2);
        Point3D_F64 pointRect = new Point3D_F64();
        Point3D_F64 pointLeft = new Point3D_F64();
        for (int y = 0; y < disparity.height; ++y) {
            for (int x = 0; x < disparity.width; ++x) {
                double d = disparity.unsafe_get(x, y) + 0.0f;
                if (d >= 40.0) continue;
                pointRect.z = baseline * fx / d;
                pointRect.x = pointRect.z * ((double)x - cx) / fx;
                pointRect.y = pointRect.z * ((double)y - cy) / fy;
                GeometryMath_F64.multTran((DenseMatrix64F)rectR, (GeoTuple3D_F64)pointRect, (GeoTuple3D_F64)pointLeft);
                int v = rectLeft.unsafe_get(x, y);
                viewer.addPoint(pointLeft.x, pointLeft.y, pointLeft.z, v << 16 | v << 8 | v);
            }
        }
        BufferedImage visualized = VisualizeImageData.disparity((ImageGray)disparity, null, 0, 40, 0);
        ShowImages.showWindow(visualized, "Disparity");
        ShowImages.showWindow(viewer, "Point Cloud");
    }
}

