/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.sfm;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.ConfigEssential;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.gui.d3.PointCloudViewer;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.SurfFeatureQueue;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class ExampleMultiviewSceneReconstruction {
    PointTransform_F64 pixelToNorm;
    double connectThreshold = 0.3;
    double inlierTol = 1.5;
    DetectDescribePoint<GrayF32, BrightFeature> detDesc = FactoryDetectDescribe.surfStable(null, null, null, GrayF32.class);
    ScoreAssociation<BrightFeature> scorer = FactoryAssociation.scoreEuclidean(BrightFeature.class, true);
    AssociateDescription<BrightFeature> associate = FactoryAssociation.greedy(this.scorer, 1.0, true);
    TriangulateTwoViewsCalibrated triangulate = FactoryMultiView.triangulateTwoGeometric();
    List<FastQueue<BrightFeature>> imageVisualFeatures = new ArrayList<FastQueue<BrightFeature>>();
    List<FastQueue<Point2D_F64>> imagePixels = new ArrayList<FastQueue<Point2D_F64>>();
    List<GrowQueue_I32> imageColors = new ArrayList<GrowQueue_I32>();
    List<List<Feature3D>> imageFeature3D = new ArrayList<List<Feature3D>>();
    Se3_F64[] motionWorldToCamera;
    boolean[] estimatedImage;
    boolean[] processedImage;
    List<Feature3D> featuresAll = new ArrayList<Feature3D>();
    ModelMatcher<Se3_F64, AssociatedPair> estimateEssential;
    ModelMatcher<Se3_F64, Point2D3D> estimatePnP;
    ModelFitter<Se3_F64, Point2D3D> refinePnP = FactoryMultiView.refinePnP(1.0E-12, 40);

    public void process(IntrinsicParameters intrinsic, List<BufferedImage> colorImages) {
        this.pixelToNorm = LensDistortionOps.transformPoint(intrinsic).undistort_F64(true, false);
        this.estimateEssential = FactoryMultiViewRobust.essentialRansac(new ConfigEssential(intrinsic), new ConfigRansac(4000, this.inlierTol));
        this.estimatePnP = FactoryMultiViewRobust.pnpRansac(new ConfigPnP(intrinsic), new ConfigRansac(4000, this.inlierTol));
        this.detectImageFeatures(colorImages);
        double[][] matrix = this.computeConnections();
        this.printConnectionMatrix(matrix);
        int bestImage = this.selectMostConnectFrame(colorImages, matrix);
        this.initializeReconstruction(colorImages, matrix, bestImage);
        ArrayList<Integer> seed = new ArrayList<Integer>();
        seed.add(bestImage);
        this.performReconstruction(seed, -1, matrix);
        PointCloudViewer gui = new PointCloudViewer(intrinsic, 1.0);
        for (Feature3D t : this.featuresAll) {
            gui.addPoint(t.worldPt.x, t.worldPt.y, t.worldPt.z, t.color);
        }
        gui.setPreferredSize(new Dimension(500, 500));
        ShowImages.showWindow(gui, "Points");
    }

    private void initializeReconstruction(List<BufferedImage> colorImages, double[][] matrix, int bestImage) {
        this.estimatedImage = new boolean[colorImages.size()];
        this.processedImage = new boolean[colorImages.size()];
        this.estimatedImage[bestImage] = true;
        this.processedImage[bestImage] = true;
        this.motionWorldToCamera = new Se3_F64[colorImages.size()];
        for (int i = 0; i < colorImages.size(); ++i) {
            this.motionWorldToCamera[i] = new Se3_F64();
            this.imageFeature3D.add(new ArrayList());
        }
        int firstChild = this.findBestFit(matrix, bestImage);
        this.initialize(bestImage, firstChild);
    }

    private int selectMostConnectFrame(List<BufferedImage> colorImages, double[][] matrix) {
        int bestImage = -1;
        int bestCount = 0;
        for (int i = 0; i < colorImages.size(); ++i) {
            int count = 0;
            for (int j = 0; j < colorImages.size(); ++j) {
                if (!(matrix[i][j] > this.connectThreshold)) continue;
                ++count;
            }
            System.out.println(i + "  count " + count);
            if (count <= bestCount) continue;
            bestCount = count;
            bestImage = i;
        }
        return bestImage;
    }

    private void detectImageFeatures(List<BufferedImage> colorImages) {
        System.out.println("Detecting Features in each image.  Total " + colorImages.size());
        for (int i = 0; i < colorImages.size(); ++i) {
            System.out.print("*");
            BufferedImage colorImage = colorImages.get(i);
            SurfFeatureQueue features = new SurfFeatureQueue(64);
            FastQueue pixels = new FastQueue(Point2D_F64.class, true);
            GrowQueue_I32 colors = new GrowQueue_I32();
            this.detectFeatures(colorImage, features, (FastQueue<Point2D_F64>)pixels, colors);
            this.imageVisualFeatures.add(features);
            this.imagePixels.add((FastQueue<Point2D_F64>)pixels);
            this.imageColors.add(colors);
        }
        System.out.println();
    }

    private double[][] computeConnections() {
        double[][] matrix = new double[this.imageVisualFeatures.size()][this.imageVisualFeatures.size()];
        for (int i = 0; i < this.imageVisualFeatures.size(); ++i) {
            for (int j = i + 1; j < this.imageVisualFeatures.size(); ++j) {
                System.out.printf("Associated %02d %02d ", i, j);
                this.associate.setSource(this.imageVisualFeatures.get(i));
                this.associate.setDestination(this.imageVisualFeatures.get(j));
                this.associate.associate();
                matrix[i][j] = (double)this.associate.getMatches().size() / (double)this.imageVisualFeatures.get(i).size();
                matrix[j][i] = (double)this.associate.getMatches().size() / (double)this.imageVisualFeatures.get(j).size();
                System.out.println(" = " + matrix[i][j]);
            }
        }
        return matrix;
    }

    private void printConnectionMatrix(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                if (matrix[i][j] >= this.connectThreshold) {
                    System.out.print("#");
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    private void detectFeatures(BufferedImage colorImage, FastQueue<BrightFeature> features, FastQueue<Point2D_F64> pixels, GrowQueue_I32 colors) {
        GrayF32 image = ConvertBufferedImage.convertFrom(colorImage, (GrayF32)null);
        features.reset();
        pixels.reset();
        colors.reset();
        this.detDesc.detect(image);
        for (int i = 0; i < this.detDesc.getNumberOfFeatures(); ++i) {
            Point2D_F64 p = this.detDesc.getLocation(i);
            ((BrightFeature)features.grow()).set(this.detDesc.getDescription(i));
            this.pixelToNorm.compute(p.x, p.y, (Point2D_F64)pixels.grow());
            colors.add(colorImage.getRGB((int)p.x, (int)p.y));
        }
    }

    private int findBestFit(double[][] matrix, int target) {
        int bestIndex = -1;
        double bestRatio = 0.0;
        for (int i = 0; i < this.estimatedImage.length; ++i) {
            double ratio = matrix[target][i];
            if (!(ratio > bestRatio)) continue;
            bestRatio = ratio;
            bestIndex = i;
        }
        return bestIndex;
    }

    private void initialize(int imageA, int imageB) {
        System.out.println("Initializing 3D world using " + imageA + " and " + imageB);
        Se3_F64 motionAtoB = new Se3_F64();
        ArrayList<AssociatedIndex> inliers = new ArrayList<AssociatedIndex>();
        if (!this.estimateStereoPose(imageA, imageB, motionAtoB, inliers)) {
            throw new RuntimeException("The first image pair is a bad keyframe!");
        }
        this.motionWorldToCamera[imageB].set(motionAtoB);
        this.estimatedImage[imageB] = true;
        this.processedImage[imageB] = true;
        FastQueue<Point2D_F64> pixelsA = this.imagePixels.get(imageA);
        FastQueue<Point2D_F64> pixelsB = this.imagePixels.get(imageB);
        List<Feature3D> tracksA = this.imageFeature3D.get(imageA);
        List<Feature3D> tracksB = this.imageFeature3D.get(imageB);
        GrowQueue_I32 colorsA = this.imageColors.get(imageA);
        for (int i = 0; i < inliers.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            Feature3D t = new Feature3D();
            t.color = colorsA.get(a.src);
            ((Point2D_F64)t.obs.grow()).set((Point2D_F64)pixelsA.get(a.src));
            ((Point2D_F64)t.obs.grow()).set((Point2D_F64)pixelsB.get(a.dst));
            t.frame.add(imageA);
            t.frame.add(imageB);
            Point2D_F64 pa = (Point2D_F64)pixelsA.get(a.src);
            Point2D_F64 pb = (Point2D_F64)pixelsB.get(a.dst);
            if (!this.triangulate.triangulate(pa, pb, motionAtoB, t.worldPt) || !(t.worldPt.z > 0.0)) continue;
            this.featuresAll.add(t);
            tracksA.add(t);
            tracksB.add(t);
        }
        this.normalizeScale(this.motionWorldToCamera[imageB], tracksA);
    }

    private void performReconstruction(List<Integer> parents, int childAdd, double[][] matrix) {
        System.out.println("--------- Total Parents " + parents.size());
        ArrayList<Integer> children = new ArrayList<Integer>();
        if (childAdd != -1) {
            children.add(childAdd);
        }
        for (int parent : parents) {
            for (int i = 0; i < this.estimatedImage.length; ++i) {
                if (!(matrix[parent][i] > this.connectThreshold) || this.processedImage[i]) continue;
                this.estimateMotionPnP(parent, i);
                children.add(i);
            }
        }
        if (!children.isEmpty()) {
            this.performReconstruction(children, -1, matrix);
        }
    }

    private void estimateMotionPnP(int imageA, int imageB) {
        Feature3D t;
        this.processedImage[imageB] = true;
        System.out.println("Estimating PnP motion between " + imageA + " and " + imageB);
        Se3_F64 dummy = new Se3_F64();
        ArrayList<AssociatedIndex> inliers = new ArrayList<AssociatedIndex>();
        if (!this.estimateStereoPose(imageA, imageB, dummy, inliers)) {
            throw new RuntimeException("The first image pair is a bad keyframe!");
        }
        FastQueue<Point2D_F64> pixelsA = this.imagePixels.get(imageA);
        FastQueue<Point2D_F64> pixelsB = this.imagePixels.get(imageB);
        List<Feature3D> featuresA = this.imageFeature3D.get(imageA);
        List<Feature3D> featuresB = this.imageFeature3D.get(imageB);
        ArrayList<Point2D3D> features = new ArrayList<Point2D3D>();
        ArrayList<AssociatedIndex> inputRansac = new ArrayList<AssociatedIndex>();
        ArrayList<AssociatedIndex> unmatched = new ArrayList<AssociatedIndex>();
        for (int i = 0; i < inliers.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)inliers.get(i);
            Feature3D t2 = this.lookupFeature(featuresA, imageA, (Point2D_F64)pixelsA.get(a.src));
            if (t2 != null) {
                Point2D_F64 p = (Point2D_F64)pixelsB.get(a.dst);
                features.add(new Point2D3D(p, t2.worldPt));
                inputRansac.add(a);
                continue;
            }
            unmatched.add(a);
        }
        if (features.size() < 15) {
            System.out.println("  Too few features for PnP!!  " + features.size());
            return;
        }
        if (!this.estimatePnP.process(features)) {
            throw new RuntimeException("Motion estimation failed");
        }
        Se3_F64 motionWorldToB = new Se3_F64();
        if (!this.refinePnP.fitModel(this.estimatePnP.getMatchSet(), this.estimatePnP.getModelParameters(), (Object)motionWorldToB)) {
            throw new RuntimeException("Refine failed!?!?");
        }
        this.motionWorldToCamera[imageB].set(motionWorldToB);
        this.estimatedImage[imageB] = true;
        int N = this.estimatePnP.getMatchSet().size();
        boolean[] inlierPnP = new boolean[features.size()];
        for (int i = 0; i < N; ++i) {
            int index = this.estimatePnP.getInputIndex(i);
            AssociatedIndex a = (AssociatedIndex)inputRansac.get(index);
            Feature3D t3 = this.lookupFeature(featuresA, imageA, (Point2D_F64)pixelsA.get(a.src));
            featuresB.add(t3);
            t3.frame.add(imageB);
            ((Point2D_F64)t3.obs.grow()).set((Point2D_F64)pixelsB.get(a.dst));
            inlierPnP[index] = true;
        }
        Se3_F64 motionBtoWorld = motionWorldToB.invert(null);
        Se3_F64 motionWorldToA = this.motionWorldToCamera[imageA];
        Se3_F64 motionBtoA = motionBtoWorld.concat(motionWorldToA, null);
        Point3D_F64 pt_in_b = new Point3D_F64();
        int totalAdded = 0;
        GrowQueue_I32 colorsA = this.imageColors.get(imageA);
        for (AssociatedIndex a : unmatched) {
            if (!this.triangulate.triangulate((Point2D_F64)pixelsB.get(a.dst), (Point2D_F64)pixelsA.get(a.src), motionBtoA, pt_in_b) || !(pt_in_b.z > 0.0)) continue;
            t = new Feature3D();
            SePointOps_F64.transform((Se3_F64)motionBtoWorld, (Point3D_F64)pt_in_b, (Point3D_F64)t.worldPt);
            t.color = colorsA.get(a.src);
            ((Point2D_F64)t.obs.grow()).set((Point2D_F64)pixelsA.get(a.src));
            ((Point2D_F64)t.obs.grow()).set((Point2D_F64)pixelsB.get(a.dst));
            t.frame.add(imageA);
            t.frame.add(imageB);
            this.featuresAll.add(t);
            featuresA.add(t);
            featuresB.add(t);
            ++totalAdded;
        }
        for (int i = 0; i < features.size(); ++i) {
            AssociatedIndex a;
            if (inlierPnP[i]) continue;
            a = (AssociatedIndex)inputRansac.get(i);
            if (!this.triangulate.triangulate((Point2D_F64)pixelsB.get(a.dst), (Point2D_F64)pixelsA.get(a.src), motionBtoA, pt_in_b) || !(pt_in_b.z > 0.0)) continue;
            t = new Feature3D();
            SePointOps_F64.transform((Se3_F64)motionBtoWorld, (Point3D_F64)pt_in_b, (Point3D_F64)t.worldPt);
            t.color = colorsA.get(a.src);
            ((Point2D_F64)t.obs.grow()).set((Point2D_F64)pixelsB.get(a.dst));
            t.frame.add(imageB);
            this.featuresAll.add(t);
            featuresB.add(t);
            ++totalAdded;
        }
        System.out.println("  New added " + totalAdded + "  tracksA.size = " + featuresA.size() + "  tracksB.size = " + featuresB.size());
    }

    private Feature3D lookupFeature(List<Feature3D> features, int frameIndex, Point2D_F64 pixel) {
        block0: for (int i = 0; i < features.size(); ++i) {
            Feature3D t = features.get(i);
            for (int j = 0; j < t.frame.size(); ++j) {
                if (t.frame.get(j) != frameIndex) continue;
                Point2D_F64 o = (Point2D_F64)t.obs.get(j);
                if (o.x != pixel.x || o.y != pixel.y) continue block0;
                return t;
            }
        }
        return null;
    }

    protected boolean estimateStereoPose(int imageA, int imageB, Se3_F64 motionAtoB, List<AssociatedIndex> inliers) {
        this.associate.setSource(this.imageVisualFeatures.get(imageA));
        this.associate.setDestination(this.imageVisualFeatures.get(imageB));
        this.associate.associate();
        FastQueue<AssociatedIndex> matches = this.associate.getMatches();
        FastQueue<Point2D_F64> pixelsA = this.imagePixels.get(imageA);
        FastQueue<Point2D_F64> pixelsB = this.imagePixels.get(imageB);
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < matches.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)matches.get(i);
            pairs.add(new AssociatedPair((Point2D_F64)pixelsA.get(a.src), (Point2D_F64)pixelsB.get(a.dst)));
        }
        if (!this.estimateEssential.process(pairs)) {
            throw new RuntimeException("Motion estimation failed");
        }
        List inliersEssential = this.estimateEssential.getMatchSet();
        motionAtoB.set((Se3_F64)this.estimateEssential.getModelParameters());
        for (int i = 0; i < inliersEssential.size(); ++i) {
            int index = this.estimateEssential.getInputIndex(i);
            inliers.add((AssociatedIndex)matches.get(index));
        }
        return true;
    }

    public void normalizeScale(Se3_F64 transform, List<Feature3D> features) {
        double T = transform.T.norm();
        double scale = 1.0 / T;
        for (Se3_F64 m : this.motionWorldToCamera) {
            m.T.timesIP(scale);
        }
        for (Feature3D t : features) {
            t.worldPt.timesIP(scale);
        }
    }

    public static void main(String[] args) {
        String directory = UtilIO.pathExample("sfm/chair");
        IntrinsicParameters intrinsic = (IntrinsicParameters)UtilIO.loadXML(directory, "/intrinsic_DSC-HX5_3648x2736_to_640x480.xml");
        List<BufferedImage> images = UtilImageIO.loadImages(directory, ".*jpg");
        ExampleMultiviewSceneReconstruction example = new ExampleMultiviewSceneReconstruction();
        long before = System.currentTimeMillis();
        example.process(intrinsic, images);
        long after = System.currentTimeMillis();
        System.out.println("Elapsed time " + (double)(after - before) / 1000.0 + " (s)");
    }

    public static class Feature3D {
        int color;
        Point3D_F64 worldPt = new Point3D_F64();
        FastQueue<Point2D_F64> obs = new FastQueue(Point2D_F64.class, true);
        GrowQueue_I32 frame = new GrowQueue_I32();
    }
}

