/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.recognition;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.feature.color.GHistogramFeatureOps;
import boofcv.alg.feature.color.HistogramFeatureOps;
import boofcv.alg.feature.color.Histogram_F64;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;

public class ExampleColorHistogramLookup {
    public static List<double[]> coupledHueSat(List<File> images) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        Planar<GrayF32> rgb = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        Planar<GrayF32> hsv = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        for (File f : images) {
            BufferedImage buffered = UtilImageIO.loadImage(f.getPath());
            if (buffered == null) {
                throw new RuntimeException("Can't load image!");
            }
            rgb.reshape(buffered.getWidth(), buffered.getHeight());
            hsv.reshape(buffered.getWidth(), buffered.getHeight());
            ConvertBufferedImage.convertFrom(buffered, rgb, true);
            ColorHsv.rgbToHsv_F32(rgb, hsv);
            Planar<GrayF32> hs = hsv.partialSpectrum(0, 1);
            Histogram_F64 histogram = new Histogram_F64(12, 12);
            histogram.setRange(0, 0.0, Math.PI * 2);
            histogram.setRange(1, 0.0, 1.0);
            GHistogramFeatureOps.histogram(hs, histogram);
            UtilFeature.normalizeL2(histogram);
            points.add(histogram.value);
        }
        return points;
    }

    public static List<double[]> independentHueSat(List<File> images) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        TupleDesc_F64 histogramHue = new TupleDesc_F64(30);
        TupleDesc_F64 histogramValue = new TupleDesc_F64(30);
        ArrayList<TupleDesc_F64> histogramList = new ArrayList<TupleDesc_F64>();
        histogramList.add(histogramHue);
        histogramList.add(histogramValue);
        Planar<GrayF32> rgb = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        Planar<GrayF32> hsv = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        for (File f : images) {
            BufferedImage buffered = UtilImageIO.loadImage(f.getPath());
            if (buffered == null) {
                throw new RuntimeException("Can't load image!");
            }
            rgb.reshape(buffered.getWidth(), buffered.getHeight());
            hsv.reshape(buffered.getWidth(), buffered.getHeight());
            ConvertBufferedImage.convertFrom(buffered, rgb, true);
            ColorHsv.rgbToHsv_F32(rgb, hsv);
            GHistogramFeatureOps.histogram(hsv.getBand(0), 0.0, Math.PI * 2, histogramHue);
            GHistogramFeatureOps.histogram(hsv.getBand(1), 0.0, 1.0, histogramValue);
            TupleDesc_F64 imageHist = UtilFeature.combine(histogramList, null);
            UtilFeature.normalizeL2(imageHist);
            points.add(imageHist.value);
        }
        return points;
    }

    public static List<double[]> coupledRGB(List<File> images) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        Planar<GrayF32> rgb = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        for (File f : images) {
            BufferedImage buffered = UtilImageIO.loadImage(f.getPath());
            if (buffered == null) {
                throw new RuntimeException("Can't load image!");
            }
            rgb.reshape(buffered.getWidth(), buffered.getHeight());
            ConvertBufferedImage.convertFrom(buffered, rgb, true);
            Histogram_F64 histogram = new Histogram_F64(10, 10, 10);
            histogram.setRange(0, 0.0, 255.0);
            histogram.setRange(1, 0.0, 255.0);
            histogram.setRange(2, 0.0, 255.0);
            GHistogramFeatureOps.histogram(rgb, histogram);
            UtilFeature.normalizeL2(histogram);
            points.add(histogram.value);
        }
        return points;
    }

    public static List<double[]> histogramGray(List<File> images) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        GrayU8 gray = new GrayU8(1, 1);
        for (File f : images) {
            BufferedImage buffered = UtilImageIO.loadImage(f.getPath());
            if (buffered == null) {
                throw new RuntimeException("Can't load image!");
            }
            gray.reshape(buffered.getWidth(), buffered.getHeight());
            ConvertBufferedImage.convertFrom(buffered, gray, true);
            TupleDesc_F64 imageHist = new TupleDesc_F64(150);
            HistogramFeatureOps.histogram(gray, 255, imageHist);
            UtilFeature.normalizeL2(imageHist);
            points.add(imageHist.value);
        }
        return points;
    }

    public static void main(String[] args) {
        String regex = UtilIO.pathExample("recognition/vacation") + "/^\\w*.jpg";
        List<File> images = Arrays.asList(BoofMiscOps.findMatches(regex));
        Collections.sort(images);
        List<double[]> points = ExampleColorHistogramLookup.coupledHueSat(images);
        int target = 0;
        double[] targetPoint = points.get(target);
        NearestNeighbor nn = FactoryNearestNeighbor.exhaustive();
        FastQueue results = new FastQueue(NnData.class, true);
        nn.init(targetPoint.length);
        nn.setPoints(points, images);
        nn.findNearest(targetPoint, -1.0, 10, results);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(UtilImageIO.loadImage(images.get(target).getPath()), "Target", ScaleOptions.ALL);
        Collections.sort(results.toList(), new Comparator<NnData>(){

            @Override
            public int compare(NnData o1, NnData o2) {
                if (o1.distance < o2.distance) {
                    return -1;
                }
                if (o1.distance > o2.distance) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 1; i < results.size; ++i) {
            File file = (File)((NnData)results.get((int)i)).data;
            double error = ((NnData)results.get((int)i)).distance;
            BufferedImage image = UtilImageIO.loadImage(file.getPath());
            gui.addImage(image, String.format("Error %6.3f", error), ScaleOptions.ALL);
        }
        ShowImages.showWindow(gui, "Similar Images", true);
    }
}

