/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.image.ImagePyramidPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import java.awt.image.BufferedImage;

public class ExamplePyramidFloat<T extends ImageGray> {
    Class<T> imageType;
    PyramidFloat<T> pyramid;

    public ExamplePyramidFloat(Class<T> imageType) {
        this.imageType = imageType;
    }

    public void standard() {
        double[] scales = new double[]{1.0, 1.5, 2.0, 2.5, 3.0, 5.0, 8.0, 15.0};
        double[] sigmas = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        this.pyramid = FactoryPyramid.floatGaussian(scales, sigmas, this.imageType);
    }

    public void process(BufferedImage image) {
        Object input = ConvertBufferedImage.convertFromSingle(image, null, this.imageType);
        this.pyramid.process(input);
        ImagePyramidPanel<T> gui = new ImagePyramidPanel<T>();
        gui.set(this.pyramid, true);
        gui.render();
        ShowImages.showWindow(gui, "Image Pyramid Float");
        ImageBase imageAtScale = this.pyramid.getLayer(1);
        ShowImages.showWindow(ConvertBufferedImage.convertTo(imageAtScale, null, true), "Image at layer 1");
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("standard/barbara.jpg"));
        ExamplePyramidFloat<GrayF32> app = new ExamplePyramidFloat<GrayF32>(GrayF32.class);
        app.standard();
        app.process(image);
    }
}

