/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;
import java.io.File;

public class ExampleMorphologicalThinning {
    public static void main(String[] args) {
        String[] images = new String[]{"drawings/drawing_text.png", "standard/fingerprint.jpg", "drawings/drawing_face.png"};
        ListDisplayPanel uberPanel = new ListDisplayPanel();
        for (String path : images) {
            BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample(path));
            GrayF32 input = ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class);
            GrayU8 binary = new GrayU8(input.width, input.height);
            GThresholdImageOps.threshold(input, binary, 120.0, true);
            GrayU8 thinned = BinaryImageOps.thin(binary, -1, null);
            BufferedImage visualBinary = VisualizeBinaryData.renderBinary(binary, false, null);
            BufferedImage visualThinned = VisualizeBinaryData.renderBinary(thinned, false, null);
            ListDisplayPanel panel = new ListDisplayPanel();
            panel.addImage(visualThinned, "Thinned");
            panel.addImage(visualBinary, "Binary");
            panel.addImage(image, "Original");
            uberPanel.addItem(panel, new File(path).getName());
        }
        ShowImages.showWindow(uberPanel, "Thinned/Skeletonalized Images", true);
    }
}

