/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.shapes.FitData;
import boofcv.alg.shapes.ShapeFittingOps;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.shapes.EllipseRotated_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ExampleFitEllipse {
    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("/home/sergei/work/dmelt/boofcv/Particles01.jpg"));
        GrayF32 input = ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class);
        GrayU8 binary = new GrayU8(input.width, input.height);
        double mean = ImageStatistics.mean(input);
        ThresholdImageOps.threshold(input, binary, (float)mean, true);
        GrayU8 filtered = BinaryImageOps.erode8(binary, 1, null);
        filtered = BinaryImageOps.dilate8(filtered, 1, null);
        List<Contour> contours = BinaryImageOps.contour(filtered, ConnectRule.EIGHT, null);
        Graphics2D g2 = image.createGraphics();
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(Color.RED);
        for (Contour c : contours) {
            FitData<EllipseRotated_F64> ellipse = ShapeFittingOps.fitEllipse_I32(c.external, 0, false, null);
            VisualizeShapes.drawEllipse((EllipseRotated_F64)ellipse.shape, g2);
        }
        ShowImages.showWindow(image, "Ellipses", true);
    }
}

