/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.calibration;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.core.image.border.BorderType;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;

public class ExampleRemoveLensDistortion {
    public static void main(String[] args) {
        String calibDir = UtilIO.pathExample("calibration/mono/Sony_DSC-HX5V_Chess/");
        String imageDir = UtilIO.pathExample("structure/");
        IntrinsicParameters param = (IntrinsicParameters)UtilIO.loadXML(calibDir, "intrinsic.xml");
        BufferedImage orig = UtilImageIO.loadImage(imageDir, "dist_cyto_01.jpg");
        Planar<GrayF32> distortedImg = ConvertBufferedImage.convertFromMulti(orig, null, true, GrayF32.class);
        int numBands = distortedImg.getNumBands();
        ImageDistort<Planar<GrayF32>, Planar<GrayF32>> allInside = LensDistortionOps.imageRemoveDistortion(AdjustmentType.EXPAND, BorderType.ZERO, param, null, ImageType.pl(numBands, GrayF32.class));
        ImageDistort<Planar<GrayF32>, Planar<GrayF32>> fullView = LensDistortionOps.imageRemoveDistortion(AdjustmentType.FULL_VIEW, BorderType.ZERO, param, null, ImageType.pl(numBands, GrayF32.class));
        ExampleRemoveLensDistortion.displayResults(orig, distortedImg, allInside, fullView);
    }

    private static void displayResults(BufferedImage orig, Planar<GrayF32> distortedImg, ImageDistort allInside, ImageDistort fullView) {
        Planar<GrayF32> undistortedImg = new Planar<GrayF32>(GrayF32.class, distortedImg.getWidth(), distortedImg.getHeight(), distortedImg.getNumBands());
        allInside.apply(distortedImg, undistortedImg);
        BufferedImage out1 = ConvertBufferedImage.convertTo(undistortedImg, null, true);
        fullView.apply(distortedImg, undistortedImg);
        BufferedImage out2 = ConvertBufferedImage.convertTo(undistortedImg, null, true);
        ListDisplayPanel panel = new ListDisplayPanel();
        panel.addItem(new ImagePanel(orig), "Original");
        panel.addItem(new ImagePanel(out1), "Undistorted All Inside");
        panel.addItem(new ImagePanel(out2), "Undistorted Full View");
        ShowImages.showWindow(panel, "Removing Lens Distortion", true);
    }
}

