/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.calibration;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ExampleDetectCalibrationPoints {
    public static void main(String[] args) {
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        BufferedImage orig = UtilImageIO.loadImage(directory + "/left01.jpg");
        GrayF32 input = ConvertBufferedImage.convertFrom(orig, (GrayF32)null);
        CalibrationDetectorChessboard detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        if (!detector.process(input)) {
            throw new RuntimeException("Target detection failed!");
        }
        CalibrationObservation set = detector.getDetectedPoints();
        Graphics2D g2 = orig.createGraphics();
        for (CalibrationObservation.Point p : set.points) {
            VisualizeFeatures.drawPoint(g2, (int)p.pixel.x, (int)p.pixel.y, 3, Color.RED);
        }
        ShowImages.showWindow(orig, "Calibration Points", true);
    }
}

