/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.pyramid;

import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.image.ImagePyramidPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VisualizeScaleSpacePyramidApp<T extends ImageGray>
extends SelectInputPanel {
    double[] scales = new double[]{1.0, 1.2, 2.4, 3.6, 4.8, 6.0, 12.0, 20.0};
    Class<T> imageType;
    ImagePyramidPanel<T> gui = new ImagePyramidPanel();
    boolean processedImage = false;

    public VisualizeScaleSpacePyramidApp(Class<T> imageType) {
        this.imageType = imageType;
        this.gui.setShowScales(false);
        this.setMainGUI(this.gui);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        final ImageGray gray = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        PyramidFloat<ImageGray> pyramid = FactoryPyramid.scaleSpace(this.scales, this.imageType);
        pyramid.process(gray);
        this.gui.set(pyramid, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeScaleSpacePyramidApp.this.gui.render();
                VisualizeScaleSpacePyramidApp.this.gui.repaint();
                VisualizeScaleSpacePyramidApp.this.setPreferredSize(new Dimension(gray.width + 50, gray.height + 20));
                VisualizeScaleSpacePyramidApp.this.processedImage = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        VisualizeScaleSpacePyramidApp<GrayU8> app = new VisualizeScaleSpacePyramidApp<GrayU8>(GrayU8.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Float Pyramid", true);
    }
}

