/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.tld.TldParameters;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.image.ShowImages;
import boofcv.gui.tracker.TldVisualizationPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.shapes.Rectangle2D_F64;
import java.awt.image.BufferedImage;

public class VisualizeTldTrackerApp<T extends ImageGray, D extends ImageGray>
implements TldVisualizationPanel.Listener {
    TldTracker<T, D> tracker;
    TldVisualizationPanel gui = new TldVisualizationPanel(this);
    T image;
    boolean paused;

    public VisualizeTldTrackerApp(Class<T> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        InterpolatePixelS<T> interpolate = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        this.tracker = new TldTracker(new TldParameters(), interpolate, gradient, imageType, derivType);
    }

    public void process(SimpleImageSequence<T> sequence) {
        if (!sequence.hasNext()) {
            throw new IllegalArgumentException("Empty sequence");
        }
        this.image = (ImageGray)sequence.next();
        this.gui.setFrame((BufferedImage)sequence.getGuiImage());
        ShowImages.showWindow(this.gui, "TLD Tracker", true);
        this.paused = true;
        while (this.paused) {
            Thread.yield();
        }
        int totalFrames = 0;
        long totalTime = 0L;
        while (sequence.hasNext()) {
            ++totalFrames;
            this.image = (ImageGray)sequence.next();
            this.gui.setFrame((BufferedImage)sequence.getGuiImage());
            long before = System.nanoTime();
            boolean success = this.tracker.track(this.image);
            long after = System.nanoTime();
            System.out.println("FPS = " + (double)totalFrames / ((double)(totalTime += after - before) / 2.0E9));
            this.gui.update(this.tracker, success);
            if (!success) {
                System.out.println("No rectangle found");
            } else {
                Rectangle2D_F64 r = this.tracker.getTargetRegion();
                System.out.println("Target: " + r);
            }
            this.gui.repaint();
            while (this.paused) {
                Thread.yield();
            }
        }
        System.out.println("DONE");
    }

    @Override
    public void startTracking(int x0, int y0, int x1, int y1) {
        this.tracker.initialize(this.image, x0, y0, x1, y1);
        this.paused = false;
    }

    @Override
    public void togglePause() {
        this.paused = !this.paused;
    }

    public static void main(String[] args) {
        VisualizeTldTrackerApp app = new VisualizeTldTrackerApp(GrayU8.class);
        String fileName = UtilIO.pathExample("tracking/track_book.mjpeg");
        SimpleImageSequence<GrayU8> sequence = DefaultMediaManager.INSTANCE.openVideo(fileName, ImageType.single(GrayU8.class));
        app.process(sequence);
    }
}

