/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.shapes;

import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThresholdControlPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    Listener listener;
    JComboBox comboType;
    JSpinner spinnerThreshold;
    JSpinner spinnerRadius;
    JSpinner spinnerScale;
    JButton buttonUpDown;
    boolean thresholdAdaptive;
    boolean thresholdGlobal;
    public ThresholdType type = ThresholdType.GLOBAL_OTSU;
    public double fixedThreshold = 50.0;
    public double scale = 0.95;
    public boolean down = true;
    public int radius = 10;
    public float savolaK = 0.3f;
    public int minPixelValue = 0;
    public int maxPixelValue = 255;
    public double minimumSpread = 10.0;

    public ThresholdControlPanel(Listener listener) {
        this.listener = listener;
        this.comboType = new JComboBox();
        for (ThresholdType type : ThresholdType.values()) {
            this.comboType.addItem(type.name());
        }
        this.comboType.setMaximumSize(this.comboType.getPreferredSize());
        this.comboType.setSelectedIndex(this.type.ordinal());
        this.spinnerThreshold = new JSpinner(new SpinnerNumberModel(this.fixedThreshold, 0.0, 255.0, 1.0));
        this.spinnerThreshold.setMaximumSize(this.spinnerThreshold.getPreferredSize());
        this.spinnerRadius = new JSpinner(new SpinnerNumberModel(this.radius, 1, 50, 1));
        this.spinnerRadius.setMaximumSize(this.spinnerRadius.getPreferredSize());
        this.spinnerScale = new JSpinner(new SpinnerNumberModel(this.scale, 0.0, 2.0, 0.05));
        this.configureSpinnerFloat(this.spinnerScale);
        this.buttonUpDown = new JButton();
        this.buttonUpDown.setPreferredSize(new Dimension(100, 30));
        this.buttonUpDown.setMaximumSize(this.buttonUpDown.getPreferredSize());
        this.buttonUpDown.setMinimumSize(this.buttonUpDown.getPreferredSize());
        this.setToggleText(this.down);
        this.comboType.addActionListener(this);
        this.spinnerThreshold.addChangeListener(this);
        this.spinnerRadius.addChangeListener(this);
        this.spinnerScale.addChangeListener(this);
        this.buttonUpDown.addActionListener(this);
        this.addLabeled(this.comboType, "Type", this);
        this.addLabeled(this.spinnerThreshold, "Threshold", this);
        this.addLabeled(this.spinnerRadius, "Radius", this);
        this.addLabeled(this.spinnerScale, "Scale", this);
        this.addAlignCenter(this.buttonUpDown, this);
        this.updateEnabledByType();
    }

    private void configureSpinnerFloat(JSpinner spinner) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(3);
        format.setMinimumIntegerDigits(1);
        editor.getTextField().setHorizontalAlignment(0);
        Dimension d = spinner.getPreferredSize();
        d.width = 60;
        spinner.setPreferredSize(d);
        spinner.addChangeListener(this);
        spinner.setMaximumSize(d);
    }

    private void setToggleText(boolean direction) {
        if (direction) {
            this.buttonUpDown.setText("down");
        } else {
            this.buttonUpDown.setText("Up");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboType) {
            this.type = ThresholdType.values()[this.comboType.getSelectedIndex()];
            this.updateEnabledByType();
            this.listener.imageThresholdUpdated();
        } else if (e.getSource() == this.buttonUpDown) {
            this.down = !this.down;
            this.setToggleText(this.down);
            this.listener.imageThresholdUpdated();
        }
    }

    private void updateEnabledByType() {
        switch (this.type) {
            case FIXED: {
                this.thresholdAdaptive = false;
                break;
            }
            case GLOBAL_ENTROPY: 
            case GLOBAL_OTSU: {
                this.thresholdAdaptive = true;
                this.thresholdGlobal = true;
                break;
            }
            default: {
                this.thresholdAdaptive = true;
                this.thresholdGlobal = false;
            }
        }
        if (this.thresholdAdaptive) {
            this.spinnerThreshold.setEnabled(false);
            if (this.thresholdGlobal) {
                this.spinnerRadius.setEnabled(false);
                this.spinnerScale.setEnabled(false);
            } else {
                this.spinnerRadius.setEnabled(true);
                this.spinnerScale.setEnabled(true);
            }
        } else {
            this.spinnerThreshold.setEnabled(true);
            this.spinnerRadius.setEnabled(false);
            this.spinnerScale.setEnabled(false);
        }
        this.spinnerThreshold.repaint();
        this.spinnerRadius.repaint();
        this.spinnerScale.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinnerThreshold) {
            this.fixedThreshold = ((Number)this.spinnerThreshold.getValue()).intValue();
            this.listener.imageThresholdUpdated();
        } else if (e.getSource() == this.spinnerRadius) {
            this.radius = ((Number)this.spinnerRadius.getValue()).intValue();
            this.listener.imageThresholdUpdated();
        } else if (e.getSource() == this.spinnerScale) {
            this.scale = ((Number)this.spinnerScale.getValue()).doubleValue();
            this.listener.imageThresholdUpdated();
        }
    }

    public ConfigThreshold createConfig() {
        ConfigThreshold config;
        if (this.type == ThresholdType.LOCAL_SQUARE_BLOCK_MIN_MAX) {
            ConfigThresholdBlockMinMax _config = new ConfigThresholdBlockMinMax();
            _config.minimumSpread = this.minimumSpread;
            config = _config;
        } else {
            config = new ConfigThreshold();
        }
        config.type = this.type;
        config.fixedThreshold = this.fixedThreshold;
        config.scale = this.scale;
        config.down = this.down;
        config.radius = this.radius;
        config.savolaK = this.savolaK;
        config.minPixelValue = this.minPixelValue;
        config.maxPixelValue = this.maxPixelValue;
        return config;
    }

    public static interface Listener {
        public void imageThresholdUpdated();
    }
}

