/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.shapes;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.shapes.FitData;
import boofcv.alg.shapes.ShapeFittingOps;
import boofcv.demonstrations.shapes.ShapeFitContourPanel;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.gui.DemonstrationBase;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ImageZoomPanel;
import boofcv.gui.image.ShowImages;
import boofcv.struct.ConnectRule;
import boofcv.struct.PointIndex_I32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.EllipseRotated_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ShapeFitContourApp
extends DemonstrationBase<GrayU8>
implements ThresholdControlPanel.Listener {
    VisualizePanel gui = new VisualizePanel();
    GrayU8 inputPrev = new GrayU8(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    GrayU8 filtered = new GrayU8(1, 1);
    boolean processImage = false;
    InputToBinary<GrayU8> inputToBinary;
    List<Contour> contours;
    BufferedImage original;
    BufferedImage work = new BufferedImage(1, 1, 1);
    ShapeFitContourPanel controlPanel = new ShapeFitContourPanel(this);

    public ShapeFitContourApp(List<String> examples) {
        super(examples, ImageType.single(GrayU8.class));
        this.add("West", this.controlPanel);
        this.add("Center", this.gui);
        ConfigThreshold config = this.controlPanel.getThreshold().createConfig();
        this.inputToBinary = FactoryThresholdBinary.threshold(config, GrayU8.class);
    }

    @Override
    public synchronized void processImage(final BufferedImage buffered, GrayU8 input) {
        if (buffered != null) {
            this.original = ShapeFitContourApp.conditionalDeclare(buffered, this.original);
            this.work = ShapeFitContourApp.conditionalDeclare(buffered, this.work);
            this.original.createGraphics().drawImage((Image)buffered, 0, 0, null);
            this.binary.reshape(input.getWidth(), input.getHeight());
            this.filtered.reshape(input.getWidth(), input.getHeight());
            this.inputPrev.setTo(input);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension d = ShapeFitContourApp.this.gui.getPreferredSize();
                    if (d.getWidth() < (double)buffered.getWidth() || d.getHeight() < (double)buffered.getHeight()) {
                        ShapeFitContourApp.this.gui.setPreferredSize(new Dimension(buffered.getWidth(), buffered.getHeight()));
                    }
                }
            });
        } else {
            input = this.inputPrev;
        }
        this.process(input);
    }

    public synchronized void viewUpdated() {
        if (this.contours == null) {
            return;
        }
        int view = this.controlPanel.getSelectedView();
        Graphics2D g2 = this.work.createGraphics();
        if (view == 0) {
            g2.drawImage((Image)this.original, 0, 0, null);
        } else if (view == 1) {
            VisualizeBinaryData.renderBinary(this.binary, false, this.work);
        } else {
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.work.getWidth(), this.work.getHeight());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShapeFitContourApp.this.gui.setScale(ShapeFitContourApp.this.controlPanel.getZoom());
                ShapeFitContourApp.this.gui.setBufferedImage(ShapeFitContourApp.this.work);
            }
        });
    }

    public void process(GrayU8 input) {
        this.inputToBinary.process(input, this.binary);
        BinaryImageOps.erode8(this.binary, 1, this.filtered);
        BinaryImageOps.dilate8(this.filtered, 1, this.binary);
        this.contours = BinaryImageOps.contour(this.binary, ConnectRule.EIGHT, null);
        this.processImage = true;
        this.viewUpdated();
    }

    @Override
    public void imageThresholdUpdated() {
        ConfigThreshold config = this.controlPanel.getThreshold().createConfig();
        this.inputToBinary = FactoryThresholdBinary.threshold(config, GrayU8.class);
        this.processImageThread(null, null);
    }

    protected void renderVisuals(Graphics2D g2, double scale) {
        block7: {
            int activeAlg;
            block6: {
                activeAlg = this.controlPanel.getSelectedAlgorithm();
                g2.setStroke(new BasicStroke(3.0f));
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.controlPanel.contoursVisible) {
                    g2.setStroke(new BasicStroke(1.0f));
                    g2.setColor(new Color(0, 100, 0));
                    VisualizeBinaryData.renderExternal(this.contours, false, true, scale, g2);
                }
                if (activeAlg != 0) break block6;
                double splitFraction = this.controlPanel.getSplitFraction();
                double minimumSplitFraction = this.controlPanel.getMinimumSplitFraction();
                for (Contour c : this.contours) {
                    List<PointIndex_I32> vertexes = ShapeFittingOps.fitPolygon(c.external, true, splitFraction, minimumSplitFraction, 100);
                    g2.setColor(Color.RED);
                    this.visualizePolygon(g2, scale, vertexes);
                    for (List<Point2D_I32> internal : c.internal) {
                        vertexes = ShapeFittingOps.fitPolygon(internal, true, splitFraction, minimumSplitFraction, 100);
                        g2.setColor(Color.GREEN);
                        this.visualizePolygon(g2, scale, vertexes);
                    }
                }
                break block7;
            }
            if (activeAlg != 1) break block7;
            for (Contour c : this.contours) {
                if (c.external.size() > 10) {
                    FitData<EllipseRotated_F64> ellipse = ShapeFittingOps.fitEllipse_I32(c.external, 0, false, null);
                    g2.setColor(Color.RED);
                    g2.setStroke(new BasicStroke(2.5f));
                    VisualizeShapes.drawEllipse((EllipseRotated_F64)ellipse.shape, scale, g2);
                }
                for (List<Point2D_I32> internal : c.internal) {
                    if (internal.size() <= 10) continue;
                    FitData<EllipseRotated_F64> ellipse = ShapeFittingOps.fitEllipse_I32(internal, 0, false, null);
                    g2.setColor(Color.GREEN);
                    g2.setStroke(new BasicStroke(2.5f));
                    VisualizeShapes.drawEllipse((EllipseRotated_F64)ellipse.shape, scale, g2);
                }
            }
        }
    }

    private void visualizePolygon(Graphics2D g2, double scale, List<PointIndex_I32> vertexes) {
        g2.setStroke(new BasicStroke(2.0f));
        VisualizeShapes.drawPolygon(vertexes, true, scale, g2);
        if (this.controlPanel.isCornersVisible()) {
            g2.setColor(Color.BLUE);
            g2.setStroke(new BasicStroke(2.0f));
            for (PointIndex_I32 p : vertexes) {
                VisualizeFeatures.drawCircle(g2, scale * ((double)p.x + 0.5), scale * ((double)p.y + 0.5), 5.0);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("particles01.jpg");
        examples.add("shapes/shapes02.png");
        examples.add("shapes/line_text_test_image.png");
        ShapeFitContourApp app = new ShapeFitContourApp(examples);
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Contour Shape Fitting", true);
    }

    class VisualizePanel
    extends ImageZoomPanel {
        VisualizePanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
            ShapeFitContourApp shapeFitContourApp = ShapeFitContourApp.this;
            synchronized (shapeFitContourApp) {
                ShapeFitContourApp.this.renderVisuals(g2, this.scale);
            }
        }
    }
}

