/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.segmentation;

import boofcv.demonstrations.segmentation.VisualizeImageSegmentationApp;
import boofcv.factory.segmentation.ConfigFh04;
import boofcv.factory.segmentation.ConfigSegmentMeanShift;
import boofcv.factory.segmentation.ConfigSlic;
import boofcv.factory.segmentation.ConfigWatershed;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.struct.ConnectRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SegmentConfigPanel
extends StandardAlgConfigPanel
implements ActionListener {
    JComboBox selectVisualize;
    JProgressBar progress = new JProgressBar();
    VisualizeImageSegmentationApp owner;
    JButton recompute = new JButton("Recompute");
    ConfigFh04 configFh = new ConfigFh04();
    ConfigSlic configSlic = new ConfigSlic(800);
    ConfigSegmentMeanShift configMeanShift = new ConfigSegmentMeanShift();
    ConfigWatershed configWatershed = new ConfigWatershed();
    JPanel panelConfig = new JPanel();
    PanelConfigFH panelFh = new PanelConfigFH();
    PanelConfigSlic panelSlic = new PanelConfigSlic();
    PanelConfigMeanShift panelMS = new PanelConfigMeanShift();
    PanelConfigWatershed panelWater = new PanelConfigWatershed();

    public SegmentConfigPanel(VisualizeImageSegmentationApp owner) {
        this.owner = owner;
        this.selectVisualize = new JComboBox<String>(new String[]{"Color", "Border", "Regions"});
        this.selectVisualize.addActionListener(this);
        this.selectVisualize.setMaximumSize(this.selectVisualize.getPreferredSize());
        this.recompute.addActionListener(this);
        this.panelConfig.setLayout(new BorderLayout());
        this.addLabeled(this.selectVisualize, "Visualize", this);
        this.addSeparator(100);
        this.addAlignCenter(this.recompute, this);
        this.addAlignCenter(this.progress, this);
        this.addAlignCenter(this.panelConfig, this);
    }

    public void setComputing(final boolean isComputing) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isComputing) {
                    SegmentConfigPanel.this.progress.setIndeterminate(true);
                    SegmentConfigPanel.this.progress.setEnabled(true);
                } else {
                    SegmentConfigPanel.this.progress.setIndeterminate(false);
                    SegmentConfigPanel.this.progress.setEnabled(false);
                }
            }
        });
    }

    protected void configHasChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SegmentConfigPanel.this.recompute.setEnabled(true);
            }
        });
    }

    public void switchAlgorithm(final int which) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SegmentConfigPanel.this.recompute.setEnabled(false);
                SegmentConfigPanel.this.panelConfig.removeAll();
                if (which == 0) {
                    SegmentConfigPanel.this.panelConfig.add((Component)SegmentConfigPanel.this.panelFh, "Center");
                } else if (which == 1) {
                    SegmentConfigPanel.this.panelConfig.add((Component)SegmentConfigPanel.this.panelSlic, "Center");
                } else if (which == 2) {
                    SegmentConfigPanel.this.panelConfig.add((Component)SegmentConfigPanel.this.panelMS, "Center");
                } else if (which == 3) {
                    SegmentConfigPanel.this.panelConfig.add((Component)SegmentConfigPanel.this.panelWater, "Center");
                }
                SegmentConfigPanel.this.panelConfig.revalidate();
                SegmentConfigPanel.this.repaint();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selectVisualize == e.getSource()) {
            this.owner.updateActiveDisplay(this.selectVisualize.getSelectedIndex());
        } else if (this.recompute == e.getSource()) {
            this.recompute.setEnabled(false);
            this.owner.recompute();
        }
    }

    public ConfigFh04 getConfigFh() {
        return this.configFh;
    }

    public ConfigSlic getConfigSlic() {
        return this.configSlic;
    }

    public ConfigSegmentMeanShift getConfigMeanShift() {
        return this.configMeanShift;
    }

    public ConfigWatershed getConfigWatershed() {
        return this.configWatershed;
    }

    private class PanelConfigWatershed
    extends StandardAlgConfigPanel
    implements ActionListener,
    ChangeListener {
        JComboBox selectConnect = new JComboBox<String>(new String[]{"4-Connect", "8-Connect"});
        JSpinner spinnerSize;

        public PanelConfigWatershed() {
            this.selectConnect.addActionListener(this);
            this.selectConnect.setMaximumSize(this.selectConnect.getPreferredSize());
            this.spinnerSize = new JSpinner(new SpinnerNumberModel(10, 0, 500, 5));
            this.spinnerSize.addChangeListener(this);
            this.spinnerSize.setMaximumSize(this.spinnerSize.getPreferredSize());
            this.configure();
            this.addAlignCenter(this.selectConnect, this);
            this.addLabeled(this.spinnerSize, "Min Size", this);
        }

        private void configure() {
            if (SegmentConfigPanel.this.configWatershed.connectRule == ConnectRule.FOUR) {
                this.selectConnect.setSelectedIndex(0);
            } else {
                this.selectConnect.setSelectedIndex(1);
            }
            this.spinnerSize.setValue(SegmentConfigPanel.this.configWatershed.minimumRegionSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.selectConnect == e.getSource()) {
                int which = this.selectConnect.getSelectedIndex();
                SegmentConfigPanel.this.configWatershed.connectRule = which == 0 ? ConnectRule.FOUR : ConnectRule.EIGHT;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.spinnerSize == e.getSource()) {
                SegmentConfigPanel.this.configWatershed.minimumRegionSize = ((Number)this.spinnerSize.getValue()).intValue();
            }
        }
    }

    private class PanelConfigMeanShift
    extends StandardAlgConfigPanel
    implements ActionListener,
    ChangeListener {
        JComboBox selectConnect = new JComboBox<String>(new String[]{"4-Connect", "8-Connect"});
        JSpinner spinnerSize;
        JSpinner spinnerSpacial;
        JSpinner spinnerColor;
        JCheckBox toggleFast;

        public PanelConfigMeanShift() {
            this.selectConnect.addActionListener(this);
            this.selectConnect.setMaximumSize(this.selectConnect.getPreferredSize());
            this.spinnerSize = new JSpinner(new SpinnerNumberModel(10, 5, 200, 5));
            this.spinnerSize.addChangeListener(this);
            this.spinnerSize.setMaximumSize(this.spinnerSize.getPreferredSize());
            this.spinnerSpacial = new JSpinner(new SpinnerNumberModel(10, 1, 50, 1));
            this.spinnerSpacial.addChangeListener(this);
            this.spinnerSpacial.setMaximumSize(this.spinnerSpacial.getPreferredSize());
            this.spinnerColor = new JSpinner(new SpinnerNumberModel(10, 5, 255, 5));
            this.spinnerColor.addChangeListener(this);
            this.spinnerColor.setMaximumSize(this.spinnerColor.getPreferredSize());
            this.toggleFast = new JCheckBox("Fast");
            this.toggleFast.addChangeListener(this);
            this.toggleFast.setMaximumSize(this.toggleFast.getPreferredSize());
            this.configure();
            this.addAlignCenter(this.selectConnect, this);
            this.addLabeled(this.spinnerSize, "Min Size", this);
            this.addLabeled(this.spinnerSpacial, "Spacial Rad", this);
            this.addLabeled(this.spinnerColor, "Color Rad", this);
            this.addAlignCenter(this.toggleFast, this);
        }

        private void configure() {
            if (SegmentConfigPanel.this.configMeanShift.connectRule == ConnectRule.FOUR) {
                this.selectConnect.setSelectedIndex(0);
            } else {
                this.selectConnect.setSelectedIndex(1);
            }
            this.spinnerSize.setValue(SegmentConfigPanel.this.configMeanShift.minimumRegionSize);
            this.spinnerSpacial.setValue(SegmentConfigPanel.this.configMeanShift.spacialRadius);
            this.spinnerColor.setValue(Float.valueOf(SegmentConfigPanel.this.configMeanShift.colorRadius));
            this.toggleFast.setSelected(SegmentConfigPanel.this.configMeanShift.fast);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.selectConnect == e.getSource()) {
                int which = this.selectConnect.getSelectedIndex();
                SegmentConfigPanel.this.configMeanShift.connectRule = which == 0 ? ConnectRule.FOUR : ConnectRule.EIGHT;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.spinnerSize == e.getSource()) {
                SegmentConfigPanel.this.configMeanShift.minimumRegionSize = ((Number)this.spinnerSize.getValue()).intValue();
            } else if (this.spinnerSpacial == e.getSource()) {
                SegmentConfigPanel.this.configMeanShift.spacialRadius = ((Number)this.spinnerSpacial.getValue()).intValue();
            } else if (this.spinnerColor == e.getSource()) {
                SegmentConfigPanel.this.configMeanShift.colorRadius = ((Number)this.spinnerColor.getValue()).intValue();
            } else if (this.toggleFast == e.getSource()) {
                SegmentConfigPanel.this.configMeanShift.fast = this.toggleFast.isSelected();
            }
        }
    }

    private class PanelConfigSlic
    extends StandardAlgConfigPanel
    implements ActionListener,
    ChangeListener {
        JComboBox selectConnect = new JComboBox<String>(new String[]{"4-Connect", "8-Connect"});
        JSpinner spinnerTotal;
        JSpinner spinnerWeight;

        public PanelConfigSlic() {
            this.selectConnect.addActionListener(this);
            this.selectConnect.setMaximumSize(this.selectConnect.getPreferredSize());
            this.spinnerTotal = new JSpinner(new SpinnerNumberModel(10, 10, 2000, 10));
            this.spinnerTotal.addChangeListener(this);
            this.spinnerTotal.setMaximumSize(this.spinnerTotal.getPreferredSize());
            this.spinnerWeight = new JSpinner(new SpinnerNumberModel(10, 10, 1000, 10));
            this.spinnerWeight.addChangeListener(this);
            this.spinnerWeight.setMaximumSize(this.spinnerWeight.getPreferredSize());
            this.configure();
            this.addAlignCenter(this.selectConnect, this);
            this.addLabeled(this.spinnerTotal, "Regions", this);
            this.addLabeled(this.spinnerWeight, "Weight", this);
        }

        private void configure() {
            if (SegmentConfigPanel.this.configSlic.connectRule == ConnectRule.FOUR) {
                this.selectConnect.setSelectedIndex(0);
            } else {
                this.selectConnect.setSelectedIndex(1);
            }
            this.spinnerTotal.setValue(SegmentConfigPanel.this.configSlic.numberOfRegions);
            this.spinnerWeight.setValue(Float.valueOf(SegmentConfigPanel.this.configSlic.spacialWeight));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.selectConnect == e.getSource()) {
                int which = this.selectConnect.getSelectedIndex();
                SegmentConfigPanel.this.configSlic.connectRule = which == 0 ? ConnectRule.FOUR : ConnectRule.EIGHT;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.spinnerTotal == e.getSource()) {
                SegmentConfigPanel.this.configSlic.numberOfRegions = ((Number)this.spinnerTotal.getValue()).intValue();
            } else if (this.spinnerWeight == e.getSource()) {
                SegmentConfigPanel.this.configSlic.spacialWeight = ((Number)this.spinnerWeight.getValue()).floatValue();
            }
        }
    }

    private class PanelConfigFH
    extends StandardAlgConfigPanel
    implements ActionListener,
    ChangeListener {
        JComboBox selectConnect = new JComboBox<String>(new String[]{"4-Connect", "8-Connect"});
        JSpinner spinnerSize;
        JSpinner spinnerK;

        public PanelConfigFH() {
            this.selectConnect.addActionListener(this);
            this.selectConnect.setMaximumSize(this.selectConnect.getPreferredSize());
            this.spinnerSize = new JSpinner(new SpinnerNumberModel(10, 5, 200, 5));
            this.spinnerSize.addChangeListener(this);
            this.spinnerSize.setMaximumSize(this.spinnerSize.getPreferredSize());
            this.spinnerK = new JSpinner(new SpinnerNumberModel(10, 10, 4000, 100));
            this.spinnerK.addChangeListener(this);
            this.spinnerK.setMaximumSize(this.spinnerK.getPreferredSize());
            this.configure();
            this.addAlignCenter(this.selectConnect, this);
            this.addLabeled(this.spinnerSize, "Min Size", this);
            this.addLabeled(this.spinnerK, "K", this);
        }

        private void configure() {
            if (SegmentConfigPanel.this.configFh.connectRule == ConnectRule.FOUR) {
                this.selectConnect.setSelectedIndex(0);
            } else {
                this.selectConnect.setSelectedIndex(1);
            }
            this.spinnerSize.setValue(SegmentConfigPanel.this.configFh.minimumRegionSize);
            this.spinnerK.setValue(Float.valueOf(SegmentConfigPanel.this.configFh.K));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.selectConnect == e.getSource()) {
                int which = this.selectConnect.getSelectedIndex();
                SegmentConfigPanel.this.configFh.connectRule = which == 0 ? ConnectRule.FOUR : ConnectRule.EIGHT;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SegmentConfigPanel.this.configHasChange();
            if (this.spinnerSize == e.getSource()) {
                SegmentConfigPanel.this.configFh.minimumRegionSize = ((Number)this.spinnerSize.getValue()).intValue();
            } else if (this.spinnerK == e.getSource()) {
                SegmentConfigPanel.this.configFh.K = ((Number)this.spinnerK.getValue()).floatValue();
            }
        }
    }
}

