/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.filter;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ShowImageDerivative<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    Class<T> imageType;
    Class<D> derivType;
    ListDisplayPanel panel = new ListDisplayPanel();
    T image;
    BufferedImage original;
    boolean processedImage = false;

    public ShowImageDerivative(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.derivType = derivType;
        Helper h = new Helper(FactoryDerivative.prewitt(imageType, derivType), FactoryDerivative.hessianPrewitt(derivType));
        this.addAlgorithm(0, "Prewitt", h);
        h = new Helper(FactoryDerivative.sobel(imageType, derivType), FactoryDerivative.hessianSobel(derivType));
        this.addAlgorithm(0, "Sobel", h);
        h = new Helper(FactoryDerivative.three(imageType, derivType), FactoryDerivative.hessianThree(derivType));
        this.addAlgorithm(0, "Three", h);
        h = new Helper(FactoryDerivative.gaussian(-1.0, 3, imageType, derivType), FactoryDerivative.hessianThree(derivType));
        this.addAlgorithm(0, "Gaussian", h);
        this.setMainGUI(this.panel);
    }

    public void process(BufferedImage original) {
        this.setInputImage(original);
        this.original = original;
        this.image = ConvertBufferedImage.convertFromSingle(original, null, this.imageType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = ShowImageDerivative.this.panel.getListWidth();
                ShowImageDerivative.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.image == null) {
            return;
        }
        D derivX = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        D derivY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        this.panel.reset();
        Helper h = (Helper)cookie;
        D derivXX = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        D derivYY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        D derivXY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        h.gradient.process(this.image, derivX, derivY);
        h.hessian.process(derivX, derivY, derivXX, derivYY, derivXY);
        double max = GImageStatistics.maxAbs(derivX);
        this.panel.addImage(VisualizeImageData.colorizeSign(derivX, null, max), "X-derivative");
        max = GImageStatistics.maxAbs(derivY);
        this.panel.addImage(VisualizeImageData.colorizeSign(derivY, null, max), "Y-derivative");
        max = GImageStatistics.maxAbs(derivXX);
        this.panel.addImage(VisualizeImageData.colorizeSign(derivXX, null, max), "XX-derivative");
        max = GImageStatistics.maxAbs(derivYY);
        this.panel.addImage(VisualizeImageData.colorizeSign(derivYY, null, max), "YY-derivative");
        max = GImageStatistics.maxAbs(derivXY);
        this.panel.addImage(VisualizeImageData.colorizeSign(derivXY, null, max), "XY-derivative");
        this.processedImage = true;
        this.repaint();
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        ShowImageDerivative<GrayF32, GrayF32> app = new ShowImageDerivative<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        inputs.add(new PathLabel("xray", UtilIO.pathExample("xray01.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Derivative", true);
    }

    private class Helper {
        public ImageGradient<T, D> gradient;
        public ImageHessian<D> hessian;

        private Helper(ImageGradient<T, D> gradient, ImageHessian<D> hessian) {
            this.gradient = gradient;
            this.hessian = hessian;
        }
    }
}

