/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.filter;

import boofcv.abst.distort.FDistort;
import boofcv.alg.filter.kernel.GKernelMath;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class DisplayGaussianKernelApp<T extends ImageGray>
extends SelectAlgorithmPanel {
    int imageSize = 400;
    T largeImg;
    ListDisplayPanel panel = new ListDisplayPanel();
    Class<T> imageType;

    public DisplayGaussianKernelApp(Class<T> imageType) {
        this.imageType = imageType;
        this.largeImg = GeneralizedImageOps.createSingleBand(imageType, this.imageSize, this.imageSize);
        this.addAlgorithm("Gaussian", new DerivType(0, 0));
        this.addAlgorithm("Deriv X", new DerivType(1, 0));
        this.addAlgorithm("Deriv XX", new DerivType(2, 0));
        this.addAlgorithm("Deriv XXX", new DerivType(3, 0));
        this.addAlgorithm("Deriv XXXX", new DerivType(4, 0));
        this.addAlgorithm("Deriv XY", new DerivType(1, 1));
        this.addAlgorithm("Deriv XXY", new DerivType(2, 1));
        this.addAlgorithm("Deriv XYY", new DerivType(1, 2));
        this.addAlgorithm("Deriv XXXY", new DerivType(3, 1));
        this.addAlgorithm("Deriv XXYY", new DerivType(2, 2));
        this.addAlgorithm("Deriv XYYY", new DerivType(1, 3));
        this.setMainGUI(this.panel);
    }

    @Override
    public void setActiveAlgorithm(String name, Object cookie) {
        DerivType type = (DerivType)cookie;
        this.panel.reset();
        for (int radius = 1; radius <= 40; radius += 2) {
            int maxOrder = Math.max(type.orderX, type.orderY);
            double sigma = FactoryKernelGaussian.sigmaForRadius(radius, maxOrder);
            Class typeKer1 = FactoryKernel.getKernelType(this.imageType, 1);
            Object kerX = FactoryKernelGaussian.derivativeK(typeKer1, type.orderX, sigma, radius);
            Object kerY = FactoryKernelGaussian.derivativeK(typeKer1, type.orderY, sigma, radius);
            Kernel2D kernel = GKernelMath.convolve(kerY, kerX);
            Object smallImg = GKernelMath.convertToImage(kernel);
            new FDistort((ImageBase)smallImg, (ImageBase)this.largeImg).interpNN().scaleExt().apply();
            double maxValue = GImageStatistics.maxAbs(this.largeImg);
            BufferedImage out = VisualizeImageData.colorizeSign(this.largeImg, null, maxValue);
            this.panel.addImage(out, String.format("%5d", radius));
        }
    }

    public static void main(String[] args) {
        DisplayGaussianKernelApp<GrayF32> panel = new DisplayGaussianKernelApp<GrayF32>(GrayF32.class);
        panel.setPreferredSize(new Dimension(640, 480));
        ShowImages.showWindow(panel, "Gaussian Kernels", true);
    }

    public static class DerivType {
        int orderX;
        int orderY;

        public DerivType(int orderX, int orderY) {
            this.orderX = orderX;
            this.orderY = orderY;
        }
    }
}

