/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.feature.detect.ImageCorruptPanel;
import boofcv.factory.feature.detect.line.ConfigHoughFoot;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.ImageLinePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DetectLineApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements ImageCorruptPanel.Listener {
    Class<T> imageType;
    T input;
    T inputCorrupted;
    T blur;
    float edgeThreshold = 25.0f;
    int maxLines = 10;
    int blurRadius = 2;
    ImageLinePanel gui = new ImageLinePanel();
    boolean processedImage = false;
    ImageCorruptPanel corruptPanel;

    public DetectLineApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "Hough Polar", FactoryDetectLineAlgs.houghPolar(new ConfigHoughPolar(3, 30, 2.0, Math.PI / 180, this.edgeThreshold, this.maxLines), imageType, derivType));
        this.addAlgorithm(0, "Hough Foot", FactoryDetectLineAlgs.houghFoot(new ConfigHoughFoot(3, 8, 5, this.edgeThreshold, this.maxLines), imageType, derivType));
        this.addAlgorithm(0, "Hough Foot Sub Image", FactoryDetectLineAlgs.houghFootSub(new ConfigHoughFootSubimage(3, 8, 5, this.edgeThreshold, this.maxLines, 2, 2), imageType, derivType));
        this.addAlgorithm(0, "Grid Line", FactoryDetectLineAlgs.lineRansac(40, 30.0, 2.36, true, imageType, derivType));
        this.input = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.inputCorrupted = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.blur = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        JPanel viewArea = new JPanel(new BorderLayout());
        this.corruptPanel = new ImageCorruptPanel();
        this.corruptPanel.setListener(this);
        viewArea.add((Component)this.corruptPanel, "West");
        viewArea.add((Component)this.gui, "Center");
        this.setMainGUI(viewArea);
    }

    public void process(final BufferedImage image) {
        ((ImageGray)this.input).reshape(image.getWidth(), image.getHeight());
        ((ImageGray)this.inputCorrupted).reshape(image.getWidth(), image.getHeight());
        ((ImageGray)this.blur).reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromSingle(image, this.input, this.imageType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectLineApp.this.gui.setBackground(image);
                DetectLineApp.this.gui.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                DetectLineApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, this.getAlgorithmCookie(0));
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.corruptPanel.corruptImage(this.input, this.inputCorrupted);
        GBlurImageOps.gaussian(this.inputCorrupted, this.blur, -1.0, this.blurRadius, null);
        if (cookie instanceof DetectLine) {
            final DetectLine detector = (DetectLine)cookie;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConvertBufferedImage.convertTo(DetectLineApp.this.inputCorrupted, DetectLineApp.this.gui.background, true);
                    DetectLineApp.this.gui.setLines(detector.detect(DetectLineApp.this.blur));
                    DetectLineApp.this.gui.repaint();
                    DetectLineApp.this.processedImage = true;
                }
            });
        } else if (cookie instanceof DetectLineSegment) {
            final DetectLineSegment detector = (DetectLineSegment)cookie;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConvertBufferedImage.convertTo(DetectLineApp.this.inputCorrupted, DetectLineApp.this.gui.background, true);
                    DetectLineApp.this.gui.setLineSegments(detector.detect(DetectLineApp.this.blur));
                    DetectLineApp.this.gui.repaint();
                    DetectLineApp.this.processedImage = true;
                }
            });
        }
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        this.process(image);
    }

    @Override
    public synchronized void corruptImageChange() {
        this.doRefreshAll();
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        Class<GrayF32> derivType = GrayF32.class;
        DetectLineApp<GrayF32, GrayF32> app = new DetectLineApp<GrayF32, GrayF32>(imageType, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Objects", UtilIO.pathExample("simple_objects.jpg")));
        inputs.add(new PathLabel("Indoors", UtilIO.pathExample("lines_indoors.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Line Detection", true);
    }
}

