/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.interest;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.demonstrations.feature.detect.ImageCorruptPanel;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.FancyInterestPointRender;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DetectFeaturePointSOApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements ImageCorruptPanel.Listener {
    static int maxFeatures = 400;
    static int maxScaleFeatures = maxFeatures / 3;
    public double[] scales = new double[]{1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0};
    int radius = 2;
    float thresh = 1.0f;
    T grayImage;
    T corruptImage;
    Class<T> imageType;
    boolean processImage = false;
    BufferedImage input;
    BufferedImage workImage;
    FancyInterestPointRender render = new FancyInterestPointRender();
    ImagePanel panel;
    ImageCorruptPanel corruptPanel;

    public DetectFeaturePointSOApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        FeatureLaplacePyramid<T, D> flss = FactoryInterestPointAlgs.hessianLaplace(this.radius, this.thresh, maxScaleFeatures, imageType, derivType);
        this.addAlgorithm(0, "Hess Lap SS", FactoryInterestPoint.wrapDetector(flss, this.scales, false, imageType));
        FeatureLaplacePyramid<T, D> flp = FactoryInterestPointAlgs.hessianLaplace(this.radius, this.thresh, maxScaleFeatures, imageType, derivType);
        this.addAlgorithm(0, "Hess Lap P", FactoryInterestPoint.wrapDetector(flp, this.scales, true, imageType));
        this.addAlgorithm(0, "FastHessian", FactoryInterestPoint.fastHessian(new ConfigFastHessian(this.thresh, 2, maxScaleFeatures, 2, 9, 4, 4)));
        this.addAlgorithm(0, "SIFT", FactoryInterestPoint.sift(null, new ConfigSiftDetector(2 * maxScaleFeatures), imageType));
        JPanel viewArea = new JPanel(new BorderLayout());
        this.corruptPanel = new ImageCorruptPanel();
        this.corruptPanel.setListener(this);
        this.panel = new ImagePanel();
        viewArea.add((Component)this.corruptPanel, "West");
        viewArea.add((Component)this.panel, "Center");
        this.setMainGUI(viewArea);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        this.input = input;
        this.grayImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.corruptImage = (ImageGray)((ImageBase)this.grayImage)._createNew(((ImageGray)this.grayImage).width, ((ImageGray)this.grayImage).height);
        this.workImage = new BufferedImage(input.getWidth(), input.getHeight(), 4);
        this.panel.setBufferedImage(this.workImage);
        this.panel.setPreferredSize(new Dimension(this.workImage.getWidth(), this.workImage.getHeight()));
        this.doRefreshAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectFeaturePointSOApp.this.revalidate();
                DetectFeaturePointSOApp.this.processImage = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.input == null) {
            return;
        }
        this.corruptPanel.corruptImage(this.grayImage, this.corruptImage);
        InterestPointDetector det = (InterestPointDetector)cookie;
        det.detect(this.corruptImage);
        this.render.reset();
        for (int i = 0; i < det.getNumberOfFeatures(); ++i) {
            Point2D_F64 p = det.getLocation(i);
            int radius = (int)Math.ceil(det.getRadius(i));
            this.render.addCircle((int)p.x, (int)p.y, radius);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertBufferedImage.convertTo(DetectFeaturePointSOApp.this.corruptImage, DetectFeaturePointSOApp.this.workImage, true);
                Graphics2D g2 = DetectFeaturePointSOApp.this.workImage.createGraphics();
                g2.setStroke(new BasicStroke(3.0f));
                DetectFeaturePointSOApp.this.render.draw(g2);
                DetectFeaturePointSOApp.this.panel.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    @Override
    public synchronized void corruptImageChange() {
        this.doRefreshAll();
    }

    public static void main(String[] args) {
        DetectFeaturePointSOApp<GrayF32, GrayF32> app = new DetectFeaturePointSOApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("amoeba", UtilIO.pathExample("amoeba_shapes.jpg")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Point Feature", true);
    }
}

