/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.interest;

import boofcv.abst.feature.detect.interest.ConfigFast;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.demonstrations.feature.detect.ImageCorruptPanel;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.FancyInterestPointRender;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DetectFeaturePointApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements ImageCorruptPanel.Listener {
    static int maxFeatures = 400;
    static int maxScaleFeatures = maxFeatures / 3;
    public double[] scales = new double[]{1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0};
    int radius = 2;
    float thresh = 1.0f;
    T grayImage;
    T corruptImage;
    Class<T> imageType;
    boolean processImage = false;
    BufferedImage input;
    BufferedImage workImage;
    FancyInterestPointRender render = new FancyInterestPointRender();
    ImagePanel panel;
    ImageCorruptPanel corruptPanel;

    public DetectFeaturePointApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        ConfigGeneralDetector configExtract = new ConfigGeneralDetector(maxFeatures, this.radius, this.thresh);
        GeneralFeatureDetector alg = FactoryDetectPoint.createHarris(configExtract, false, derivType);
        this.addAlgorithm(0, "Harris", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createHarris(configExtract, true, derivType);
        this.addAlgorithm(0, "Harris Weighted", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createShiTomasi(configExtract, false, derivType);
        this.addAlgorithm(0, "Shi-Tomasi", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createShiTomasi(configExtract, true, derivType);
        this.addAlgorithm(0, "Shi-Tomasi Weighted", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createFast(new ConfigFast(10, 9), new ConfigGeneralDetector(maxFeatures, this.radius, 10.0f), imageType);
        this.addAlgorithm(0, "Fast", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createKitRos(configExtract, derivType);
        this.addAlgorithm(0, "KitRos", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createMedian(configExtract, imageType);
        this.addAlgorithm(0, "Median", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        alg = FactoryDetectPoint.createHessian(HessianBlobIntensity.Type.DETERMINANT, configExtract, derivType);
        this.addAlgorithm(0, "Hessian", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        configExtract.detectMinimums = true;
        alg = FactoryDetectPoint.createHessian(HessianBlobIntensity.Type.TRACE, configExtract, derivType);
        this.addAlgorithm(0, "Laplace", new EasyGeneralFeatureDetector(alg, imageType, derivType));
        JPanel viewArea = new JPanel(new BorderLayout());
        this.corruptPanel = new ImageCorruptPanel();
        this.corruptPanel.setListener(this);
        this.panel = new ImagePanel();
        viewArea.add((Component)this.corruptPanel, "West");
        viewArea.add((Component)this.panel, "Center");
        this.setMainGUI(viewArea);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        this.input = input;
        this.grayImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.corruptImage = (ImageGray)((ImageBase)this.grayImage)._createNew(((ImageGray)this.grayImage).width, ((ImageGray)this.grayImage).height);
        this.workImage = new BufferedImage(input.getWidth(), input.getHeight(), 4);
        this.panel.setBufferedImage(this.workImage);
        this.panel.setPreferredSize(new Dimension(this.workImage.getWidth(), this.workImage.getHeight()));
        this.doRefreshAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectFeaturePointApp.this.revalidate();
                DetectFeaturePointApp.this.processImage = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        Point2D_I16 p;
        int i;
        QueueCorner l;
        if (this.input == null) {
            return;
        }
        this.corruptPanel.corruptImage(this.grayImage, this.corruptImage);
        EasyGeneralFeatureDetector det = (EasyGeneralFeatureDetector)cookie;
        det.detect(this.corruptImage, null);
        this.render.reset();
        if (det.getDetector().isDetectMinimums()) {
            l = det.getMinimums();
            for (i = 0; i < l.size; ++i) {
                p = (Point2D_I16)l.get(i);
                this.render.addPoint(p.x, p.y, 3, Color.BLUE);
            }
        }
        if (det.getDetector().isDetectMaximums()) {
            l = det.getMaximums();
            for (i = 0; i < l.size; ++i) {
                p = (Point2D_I16)l.get(i);
                this.render.addPoint(p.x, p.y, 3, Color.RED);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertBufferedImage.convertTo(DetectFeaturePointApp.this.corruptImage, DetectFeaturePointApp.this.workImage, true);
                Graphics2D g2 = DetectFeaturePointApp.this.workImage.createGraphics();
                g2.setStroke(new BasicStroke(3.0f));
                DetectFeaturePointApp.this.render.draw(g2);
                DetectFeaturePointApp.this.panel.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    @Override
    public synchronized void corruptImageChange() {
        this.doRefreshAll();
    }

    public static void main(String[] args) {
        DetectFeaturePointApp<GrayF32, GrayF32> app = new DetectFeaturePointApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("amoeba", UtilIO.pathExample("amoeba_shapes.jpg")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Point Feature", true);
    }
}

