/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.interest;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class DetectFastHessianApp {
    static String fileName = UtilIO.pathExample("sunflowers.jpg");
    static int NUM_FEATURES = 120;

    private static <T extends ImageGray> void doStuff(Class<T> imageType, BufferedImage input) {
        ImageGray workImage = ConvertBufferedImage.convertFromSingle(input, null, imageType);
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(5, 1.0f, 5, true));
        FastHessianFeatureDetector det = new FastHessianFeatureDetector(extractor, NUM_FEATURES, 2, 9, 4, 4, 6);
        Object integral = GIntegralImageOps.transform(workImage, null);
        det.detect(integral);
        System.out.println("total features found: " + det.getFoundPoints().size());
        VisualizeFeatures.drawScalePoints(input.createGraphics(), det.getFoundPoints(), 2.0);
        ShowImages.showWindow(input, "Found Features: " + imageType.getSimpleName(), true);
    }

    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(fileName);
        DetectFastHessianApp.doStuff(GrayF32.class, input);
    }
}

