/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.IntegralImageFeatureIntensity;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class IntensityFastHessianApp {
    static String fileName = UtilIO.pathExample("sunflowers.jpg");

    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(fileName);
        GrayF32 inputF32 = ConvertBufferedImage.convertFrom(input, (GrayF32)null);
        GrayF32 integral = IntegralImageOps.transform(inputF32, null);
        GrayF32 intensity = new GrayF32(integral.width, integral.height);
        ListDisplayPanel guiIntensity = new ListDisplayPanel();
        guiIntensity.addImage(input, "Original");
        guiIntensity.addImage(VisualizeImageData.grayMagnitude((ImageGray)inputF32, null, 255.0), "Gray");
        int skip = 0;
        for (int octave = 0; octave < 4; ++octave) {
            skip = skip == 0 ? 1 : (skip += skip);
            for (int sizeIndex = 0; sizeIndex < 4; ++sizeIndex) {
                int block = 1 + skip * 2 * (sizeIndex + 1);
                int size = 3 * block;
                IntegralImageFeatureIntensity.hessian(integral, 1, size, intensity);
                float maxAbs = ImageStatistics.maxAbs(intensity);
                BufferedImage b = VisualizeImageData.colorizeSign((ImageGray)intensity, null, (double)maxAbs);
                guiIntensity.addImage(b, String.format("Oct = %2d size %3d", octave + 1, size));
            }
        }
        ShowImages.showWindow(guiIntensity, "Feature Intensity", true);
    }
}

