/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.extract;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralExtractConfigPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    JComboBox selectImage = new JComboBox();
    JSpinner selectSeparation;
    JSpinner selectThreshold;
    JSpinner selectNumFeatures;
    Listener listener;

    public GeneralExtractConfigPanel() {
        this.selectImage.addItem("Original");
        this.selectImage.addItem("Intensity");
        this.selectImage.addItem("Features");
        this.selectImage.addActionListener(this);
        this.selectImage.setMaximumSize(new Dimension(175, (int)this.selectImage.getPreferredSize().getHeight()));
        this.selectSeparation = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.selectSeparation.addChangeListener(this);
        int w = (int)this.selectSeparation.getPreferredSize().getWidth() + 20;
        int h = (int)this.selectSeparation.getPreferredSize().getHeight() + 10;
        this.selectSeparation.setPreferredSize(new Dimension(w, h));
        this.selectSeparation.setMaximumSize(new Dimension(w, h));
        this.selectThreshold = new JSpinner(new SpinnerNumberModel(0.01, 0.0, 1.0, 0.01));
        this.selectThreshold.addChangeListener(this);
        this.selectThreshold.setPreferredSize(new Dimension(w, h));
        this.selectThreshold.setMaximumSize(new Dimension(w, h));
        this.selectNumFeatures = new JSpinner(new SpinnerNumberModel(200, 0, 1000, 20));
        this.selectNumFeatures.addChangeListener(this);
        this.selectNumFeatures.setPreferredSize(new Dimension(w, h));
        this.selectNumFeatures.setMaximumSize(new Dimension(w, h));
        this.addLabeled(this.selectImage, "Display", this);
        this.addLabeled(this.selectNumFeatures, "Total", this);
        this.addLabeled(this.selectSeparation, "Separation", this);
        this.addLabeled(this.selectThreshold, "Threshold", this);
        this.add(Box.createVerticalGlue());
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setImageIndex(int index) {
        this.selectImage.setSelectedIndex(index);
    }

    public void setFeatureSeparation(int radius) {
        this.selectSeparation.setValue(radius);
    }

    public void setThreshold(double value) {
        this.selectThreshold.setValue(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.selectImage) {
            int selected = this.selectImage.getSelectedIndex();
            this.listener.changeImage(selected);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.selectThreshold) {
            double value = ((Number)this.selectThreshold.getValue()).doubleValue();
            this.listener.changeThreshold(value);
        } else if (e.getSource() == this.selectSeparation) {
            int radius = ((Number)this.selectSeparation.getValue()).intValue();
            this.listener.changeFeatureSeparation(radius);
        } else if (e.getSource() == this.selectNumFeatures) {
            int total = ((Number)this.selectNumFeatures.getValue()).intValue();
            this.listener.changeNumFeatures(total);
        }
    }

    public static interface Listener {
        public void changeImage(int var1);

        public void changeFeatureSeparation(int var1);

        public void changeThreshold(double var1);

        public void changeNumFeatures(int var1);
    }
}

