/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.edge;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GradientToEdgeFeatures;
import boofcv.alg.feature.detect.edge.HysteresisEdgeTraceMark;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.edge.VisualizeEdgeFeatures;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;

public class VisualizeCannySteps {
    static String fileName = UtilIO.pathExample("scale/beach02.jpg");

    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(fileName);
        GrayF32 inputF32 = ConvertBufferedImage.convertFrom(input, (GrayF32)null);
        GrayF32 blurred = new GrayF32(inputF32.width, inputF32.height);
        GrayF32 derivX = new GrayF32(inputF32.width, inputF32.height);
        GrayF32 derivY = new GrayF32(inputF32.width, inputF32.height);
        GrayF32 intensity = new GrayF32(inputF32.width, inputF32.height);
        GrayF32 orientation = new GrayF32(inputF32.width, inputF32.height);
        GrayF32 suppressed = new GrayF32(inputF32.width, inputF32.height);
        GrayS8 direction = new GrayS8(inputF32.width, inputF32.height);
        GrayU8 output = new GrayU8(inputF32.width, inputF32.height);
        BlurStorageFilter<GrayF32> blur = FactoryBlurFilter.gaussian(GrayF32.class, -1.0, 2);
        ImageGradient gradient = FactoryDerivative.sobel(GrayF32.class, null);
        blur.process(inputF32, blurred);
        gradient.process(blurred, derivX, derivY);
        float threshLow = 5.0f;
        float threshHigh = 40.0f;
        GradientToEdgeFeatures.intensityE(derivX, derivY, intensity);
        GradientToEdgeFeatures.direction(derivX, derivY, orientation);
        GradientToEdgeFeatures.discretizeDirection4(orientation, direction);
        GradientToEdgeFeatures.nonMaxSuppression4(intensity, direction, suppressed);
        BufferedImage renderedOrientation = VisualizeEdgeFeatures.renderOrientation4(direction, suppressed, threshLow, null);
        HysteresisEdgeTraceMark hysteresis = new HysteresisEdgeTraceMark();
        hysteresis.process(suppressed, direction, threshLow, threshHigh, output);
        BufferedImage renderedLabel = VisualizeBinaryData.renderBinary(output, false, null);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(suppressed, "Suppressed Intensity");
        gui.addImage(intensity, "Raw Intensity");
        gui.addImage(renderedOrientation, "Orientation");
        gui.addImage(renderedLabel, "Labeled Contours");
        ShowImages.showWindow(gui, "Visualized Canny Steps", true);
    }
}

