/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.edge;

import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.alg.misc.GImageStatistics;
import boofcv.demonstrations.binary.SelectHistogramThresholdPanel;
import boofcv.demonstrations.feature.detect.edge.CannyControlBar;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ShowEdgeContourApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements CannyControlBar.Listener,
SelectHistogramThresholdPanel.Listener {
    ImagePanel panel = new ImagePanel();
    BufferedImage input;
    T workImage;
    Class<T> imageType;
    Class<D> derivType;
    boolean processedImage = false;
    GrayU8 binary = new GrayU8(1, 1);
    GrayS32 labeled = new GrayS32(1, 1);
    CannyControlBar barCanny;
    SelectHistogramThresholdPanel barBinary;
    JPanel bodyPanel = new JPanel();
    int activeAlg;
    int previousBlur;
    CannyEdge<T, D> canny;
    LinearContourLabelChang2004 contour = new LinearContourLabelChang2004(ConnectRule.EIGHT);

    public ShowEdgeContourApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.derivType = derivType;
        this.addAlgorithm(0, "Canny", 0);
        this.addAlgorithm(0, "Threshold Contour", 1);
        this.barCanny = new CannyControlBar(1, 15);
        this.barCanny.setListener(this);
        this.barBinary = new SelectHistogramThresholdPanel(50, true);
        this.barBinary.setListener(this);
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.panel, "Center");
        this.bodyPanel.add((Component)this.barCanny, "North");
        this.setMainGUI(this.bodyPanel);
        this.previousBlur = this.barCanny.getBlurRadius();
        this.canny = FactoryEdgeDetectors.canny(this.previousBlur, true, true, imageType, derivType);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        this.input = input;
        this.workImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        final double threshold = GImageStatistics.mean(this.workImage);
        this.binary.reshape(((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height);
        this.labeled.reshape(((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height);
        final int width = input.getWidth();
        final int height = input.getHeight();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowEdgeContourApp.this.barBinary.setThreshold((int)threshold);
                ShowEdgeContourApp.this.barBinary.getHistogramPanel().update((ImageGray)ShowEdgeContourApp.this.workImage);
                ShowEdgeContourApp.this.panel.setPreferredSize(new Dimension(width, height));
                ShowEdgeContourApp.this.processedImage = true;
                ShowEdgeContourApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.activeAlg = (Integer)cookie;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ShowEdgeContourApp.this.activeAlg == 0) {
                    ShowEdgeContourApp.this.bodyPanel.remove(ShowEdgeContourApp.this.barBinary);
                    ShowEdgeContourApp.this.bodyPanel.add((Component)ShowEdgeContourApp.this.barCanny, "North");
                    ShowEdgeContourApp.this.barCanny.repaint();
                } else {
                    ShowEdgeContourApp.this.bodyPanel.remove(ShowEdgeContourApp.this.barCanny);
                    ShowEdgeContourApp.this.bodyPanel.add((Component)ShowEdgeContourApp.this.barBinary, "North");
                    ShowEdgeContourApp.this.barBinary.repaint();
                }
                ShowEdgeContourApp.this.validate();
            }
        });
        this.doProcess();
    }

    private void doProcess() {
        BufferedImage temp;
        if (this.input == null) {
            return;
        }
        if (this.activeAlg == 0) {
            if (this.previousBlur != this.barCanny.getBlurRadius()) {
                this.previousBlur = this.barCanny.getBlurRadius();
                this.canny = FactoryEdgeDetectors.canny(this.previousBlur, true, true, this.imageType, this.derivType);
            }
            double thresh = (double)this.barCanny.getThreshold() / 100.0;
            this.canny.process(this.workImage, (float)thresh * 0.1f, (float)thresh, null);
            List<EdgeContour> contours = this.canny.getContours();
            temp = VisualizeBinaryData.renderContours(contours, null, ((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height, null);
        } else {
            GThresholdImageOps.threshold(this.workImage, this.binary, this.barBinary.getThreshold(), this.barBinary.isDown());
            this.contour.process(this.binary, this.labeled);
            temp = VisualizeBinaryData.renderContours((List<Contour>)this.contour.getContours().toList(), null, 0xFF1010, ((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height, null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowEdgeContourApp.this.panel.setBufferedImage(temp);
                ShowEdgeContourApp.this.panel.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void changeCanny() {
        this.doProcess();
    }

    @Override
    public void histogramThresholdChange() {
        this.doProcess();
    }

    public static void main(String[] args) {
        ShowEdgeContourApp<GrayF32, GrayF32> app = new ShowEdgeContourApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("Room", UtilIO.pathExample("indoors01.jpg")));
        inputs.add(new PathLabel("Objects", UtilIO.pathExample("simple_objects.jpg")));
        inputs.add(new PathLabel("Indoors", UtilIO.pathExample("lines_indoors.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Contours", true);
        System.out.println("Done");
    }
}

