/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect;

import boofcv.abst.feature.detect.extract.WrapperNonMaximumBlock;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.alg.feature.detect.extract.NonMaxBlockStrict;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ProcessImageSequence;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.BoofVideoManager;
import boofcv.struct.BoofDefaults;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I16;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class VideoDetectCorners<T extends ImageGray, D extends ImageGray>
extends ProcessImageSequence<T> {
    GeneralFeatureDetector<T, D> detector;
    D derivX;
    D derivY;
    D derivXX;
    D derivYY;
    D derivXY;
    Class<D> derivType;
    QueueCorner corners;
    ImagePanel panel;

    public VideoDetectCorners(SimpleImageSequence<T> sequence, GeneralFeatureDetector<T, D> detector, Class<D> derivType) {
        super(sequence);
        this.derivType = derivType;
        this.detector = detector;
    }

    @Override
    public void processFrame(T image) {
        if (this.detector.getRequiresGradient()) {
            if (this.derivX == null) {
                this.derivX = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)image).width, ((ImageGray)image).height);
                this.derivY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)image).width, ((ImageGray)image).height);
            }
            GImageDerivativeOps.gradient(DerivativeType.SOBEL, image, this.derivX, this.derivY, BoofDefaults.DERIV_BORDER_TYPE);
        }
        if (this.detector.getRequiresHessian()) {
            if (this.derivXX == null) {
                this.derivXX = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)image).width, ((ImageGray)image).height);
                this.derivYY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)image).width, ((ImageGray)image).height);
                this.derivXY = GeneralizedImageOps.createSingleBand(this.derivType, ((ImageGray)image).width, ((ImageGray)image).height);
            }
            GImageDerivativeOps.hessian(DerivativeType.THREE, image, this.derivXX, this.derivYY, this.derivXY, BoofDefaults.DERIV_BORDER_TYPE);
        }
        this.detector.process(image, this.derivX, this.derivY, this.derivXX, this.derivYY, this.derivXY);
        this.corners = this.detector.getMaximums();
    }

    @Override
    public void updateGUI(BufferedImage guiImage, T origImage) {
        Graphics2D g2 = guiImage.createGraphics();
        for (int i = 0; i < this.corners.size(); ++i) {
            Point2D_I16 pt = (Point2D_I16)this.corners.get(i);
            g2.setColor(Color.BLACK);
            g2.fillOval(pt.x - 4, pt.y - 4, 9, 9);
            g2.setColor(Color.RED);
            g2.fillOval(pt.x - 2, pt.y - 2, 5, 5);
        }
        if (this.panel == null) {
            this.panel = ShowImages.showWindow(guiImage, "Image Sequence");
            this.addComponent(this.panel);
        } else {
            this.panel.setBufferedImage(guiImage);
            this.panel.repaint();
        }
    }

    public static <T extends ImageGray, D extends ImageGray> void perform(String fileName, Class<T> imageType, Class<D> derivType) {
        SimpleImageSequence<T> sequence = BoofVideoManager.loadManagerDefault().load(fileName, ImageType.single(imageType));
        int maxCorners = 200;
        int radius = 2;
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.shiTomasi(radius, false, derivType));
        WrapperNonMaximumBlock extractor = new WrapperNonMaximumBlock(new NonMaxBlockStrict.Max());
        extractor.setIgnoreBorder(radius + 10);
        extractor.setThresholdMaximum(10.0f);
        GeneralFeatureDetector detector = new GeneralFeatureDetector(intensity, extractor);
        detector.setMaxFeatures(maxCorners);
        VideoDetectCorners<T, D> display = new VideoDetectCorners<T, D>(sequence, detector, derivType);
        display.process();
    }

    public static void main(String[] args) {
        String fileName = args.length == 0 ? UtilIO.pathExample("zoom.mjpeg") : args[0];
        VideoDetectCorners.perform(fileName, GrayF32.class, GrayF32.class);
    }
}

