/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.describe;

import boofcv.demonstrations.feature.describe.VisualizeImageHogApp;
import boofcv.gui.StandardAlgConfigPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlHogPanel
extends StandardAlgConfigPanel
implements ChangeListener,
ItemListener {
    JCheckBox showInput;
    JCheckBox showGrid;
    JCheckBox showLog;
    JCheckBox showLocal;
    JSpinner selectWidth;
    JSpinner selectHistogram;
    boolean doShowGrid = false;
    boolean doShowLog = true;
    boolean doShowLocal = false;
    int cellWidth = 20;
    int histogram = 9;
    VisualizeImageHogApp owner;

    public ControlHogPanel(VisualizeImageHogApp owner) {
        this.owner = owner;
        this.showInput = new JCheckBox("Show Input");
        this.showInput.setSelected(false);
        this.showInput.addItemListener(this);
        this.showInput.setMaximumSize(this.showInput.getPreferredSize());
        this.showGrid = new JCheckBox("Show Grid");
        this.showGrid.setSelected(this.doShowGrid);
        this.showGrid.addItemListener(this);
        this.showGrid.setMaximumSize(this.showGrid.getPreferredSize());
        this.showLog = new JCheckBox("Log Intensity");
        this.showLog.setSelected(this.doShowLog);
        this.showLog.addItemListener(this);
        this.showLog.setMaximumSize(this.showLog.getPreferredSize());
        this.showLocal = new JCheckBox("Local Scaling");
        this.showLocal.setSelected(this.doShowLocal);
        this.showLocal.addItemListener(this);
        this.showLocal.setMaximumSize(this.showLocal.getPreferredSize());
        this.selectWidth = new JSpinner(new SpinnerNumberModel(this.cellWidth, 5, 50, 1));
        this.selectWidth.addChangeListener(this);
        this.selectWidth.setMaximumSize(this.selectWidth.getPreferredSize());
        this.selectHistogram = new JSpinner(new SpinnerNumberModel(this.histogram, 4, 32, 1));
        this.selectHistogram.addChangeListener(this);
        this.selectHistogram.setMaximumSize(this.selectHistogram.getPreferredSize());
        this.addAlignLeft(this.showInput, this);
        this.addAlignLeft(this.showGrid, this);
        this.addAlignLeft(this.showLog, this);
        this.addAlignLeft(this.showLocal, this);
        this.addLabeled(this.selectWidth, "Size:", this);
        this.addLabeled(this.selectHistogram, "Histogram:", this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.selectWidth == e.getSource()) {
            this.cellWidth = ((Number)this.selectWidth.getValue()).intValue();
            this.owner.setCellWidth(this.cellWidth);
        } else if (this.selectHistogram == e.getSource()) {
            this.histogram = ((Number)this.selectHistogram.getValue()).intValue();
            this.owner.setHistogram(this.histogram);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.showGrid == e.getSource()) {
            this.doShowGrid = this.showGrid.isSelected();
            this.owner.setShowGrid(this.doShowGrid);
        } else if (this.showLog == e.getSource()) {
            this.doShowLog = this.showLog.isSelected();
            this.owner.setShowLog(this.doShowLog);
        } else if (this.showLocal == e.getSource()) {
            this.doShowLocal = this.showLocal.isSelected();
            this.owner.setShowLocal(this.doShowLocal);
        } else if (this.showInput == e.getSource()) {
            this.owner.setShowInput(this.showInput.isSelected());
        }
    }
}

