/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.FastQueue;

public class VisualizeAssociationMatchesApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    InterestPointDetector<T> detector;
    DescribeRegionPoint describe;
    AssociateDescription<TupleDesc> matcher;
    OrientationImage<T> orientation;
    Planar<T> imageLeft;
    Planar<T> imageRight;
    T grayLeft;
    T grayRight;
    Class<T> imageType;
    boolean associateBackwards;
    AssociationPanel panel = new AssociationPanel(20);
    boolean processedImage = false;
    volatile int progress;

    public VisualizeAssociationMatchesApp(Class<T> imageType, Class<D> derivType) {
        super(3);
        this.imageType = imageType;
        this.addAlgorithm(0, "Fast Hessian", FactoryInterestPoint.fastHessian(new ConfigFastHessian(1.0f, 2, 200, 1, 9, 4, 4)));
        this.addAlgorithm(0, "SIFT", FactoryInterestPoint.sift(null, new ConfigSiftDetector(400), imageType));
        GeneralFeatureDetector alg = FactoryDetectPoint.createShiTomasi(new ConfigGeneralDetector(500, 2, 1.0f), false, derivType);
        this.addAlgorithm(0, "Shi-Tomasi", FactoryInterestPoint.wrapPoint(alg, 1.0, imageType, derivType));
        this.addAlgorithm(1, "SURF-S", FactoryDescribeRegionPoint.surfStable(null, imageType));
        this.addAlgorithm(1, "SURF-S Color", FactoryDescribeRegionPoint.surfColorStable(null, ImageType.pl(3, imageType)));
        this.addAlgorithm(1, "SIFT", FactoryDescribeRegionPoint.sift(null, null, imageType));
        this.addAlgorithm(1, "BRIEF", FactoryDescribeRegionPoint.brief(new ConfigBrief(true), imageType));
        this.addAlgorithm(1, "BRIEFSO", FactoryDescribeRegionPoint.brief(new ConfigBrief(false), imageType));
        this.addAlgorithm(1, "Pixel 11x11", FactoryDescribeRegionPoint.pixel(11, 11, imageType));
        this.addAlgorithm(1, "NCC 11x11", FactoryDescribeRegionPoint.pixelNCC(11, 11, imageType));
        this.addAlgorithm(2, "Greedy", false);
        this.addAlgorithm(2, "Backwards", true);
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii(null, integralType);
        this.orientation = FactoryOrientation.convertImage(orientationII, imageType);
        this.imageLeft = new Planar<T>(imageType, 1, 1, 3);
        this.imageRight = new Planar<T>(imageType, 1, 1, 3);
        this.grayLeft = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.grayRight = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.setMainGUI(this.panel);
    }

    public void process(final BufferedImage buffLeft, final BufferedImage buffRight) {
        this.imageLeft.reshape(buffLeft.getWidth(), buffLeft.getHeight());
        this.imageRight.reshape(buffRight.getWidth(), buffRight.getHeight());
        ((ImageGray)this.grayLeft).reshape(buffLeft.getWidth(), buffLeft.getHeight());
        ((ImageGray)this.grayRight).reshape(buffRight.getWidth(), buffRight.getHeight());
        ConvertBufferedImage.convertFromMulti(buffLeft, this.imageLeft, true, this.imageType);
        ConvertBufferedImage.convertFromMulti(buffRight, this.imageRight, true, this.imageType);
        GConvertImage.average(this.imageLeft, this.grayLeft);
        GConvertImage.average(this.imageRight, this.grayRight);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeAssociationMatchesApp.this.panel.setImages(buffLeft, buffRight);
                VisualizeAssociationMatchesApp.this.processedImage = true;
                VisualizeAssociationMatchesApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public synchronized void refreshAll(Object[] cookies) {
        this.detector = (InterestPointDetector)cookies[0];
        this.describe = (DescribeRegionPoint)cookies[1];
        this.associateBackwards = (Boolean)cookies[2];
        this.matcher = this.createMatcher();
        this.processImage();
    }

    private AssociateDescription createMatcher() {
        ScoreAssociation scorer = FactoryAssociation.defaultScore(this.describe.getDescriptionType());
        return FactoryAssociation.greedy(scorer, Double.MAX_VALUE, this.associateBackwards);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.detector == null || this.describe == null || this.matcher == null) {
            return;
        }
        switch (indexFamily) {
            case 0: {
                this.detector = (InterestPointDetector)cookie;
                break;
            }
            case 1: {
                this.describe = (DescribeRegionPoint)cookie;
                this.matcher = this.createMatcher();
                break;
            }
            case 2: {
                this.associateBackwards = (Boolean)cookie;
                this.matcher = this.createMatcher();
            }
        }
        this.processImage();
    }

    private void processImage() {
        final ArrayList<Point2D_F64> leftPts = new ArrayList<Point2D_F64>();
        final ArrayList<Point2D_F64> rightPts = new ArrayList<Point2D_F64>();
        FastQueue leftDesc = UtilFeature.createQueue(this.describe, 10);
        FastQueue rightDesc = UtilFeature.createQueue(this.describe, 10);
        final ProgressMonitor progressMonitor = new ProgressMonitor(this, "Associating Features", "Detecting Left", 0, 3);
        this.progress = 0;
        new Thread(){

            @Override
            public synchronized void run() {
                while (VisualizeAssociationMatchesApp.this.progress < 3) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressMonitor.setProgress(VisualizeAssociationMatchesApp.this.progress);
                        }
                    });
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                progressMonitor.close();
            }
        }.start();
        this.extractImageFeatures(this.imageLeft, this.grayLeft, leftDesc, leftPts);
        ++this.progress;
        this.extractImageFeatures(this.imageRight, this.grayRight, rightDesc, rightPts);
        ++this.progress;
        this.matcher.setSource(leftDesc);
        this.matcher.setDestination(rightDesc);
        this.matcher.associate();
        this.progress = 3;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeAssociationMatchesApp.this.panel.setAssociation(leftPts, rightPts, VisualizeAssociationMatchesApp.this.matcher.getMatches());
                VisualizeAssociationMatchesApp.this.repaint();
            }
        });
    }

    private void extractImageFeatures(Planar<T> color, T gray, FastQueue<TupleDesc> descs, List<Point2D_F64> locs) {
        this.detector.detect(gray);
        if (this.describe.getImageType().getFamily() == ImageType.Family.GRAY) {
            this.describe.setImage(gray);
        } else {
            this.describe.setImage(color);
        }
        this.orientation.setImage(gray);
        if (this.detector.hasScale()) {
            for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
                TupleDesc d;
                double yaw = 0.0;
                Point2D_F64 pt = this.detector.getLocation(i);
                double radius = this.detector.getRadius(i);
                if (this.describe.requiresOrientation()) {
                    this.orientation.setObjectRadius(radius);
                    yaw = this.orientation.compute(pt.x, pt.y);
                }
                if (this.describe.process(pt.x, pt.y, yaw, radius, d = (TupleDesc)descs.grow())) {
                    locs.add(pt.copy());
                    continue;
                }
                descs.removeTail();
            }
        } else {
            this.orientation.setObjectRadius(10.0);
            for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
                TupleDesc d;
                double yaw = 0.0;
                Point2D_F64 pt = this.detector.getLocation(i);
                if (this.describe.requiresOrientation()) {
                    yaw = this.orientation.compute(pt.x, pt.y);
                }
                if (this.describe.process(pt.x, pt.y, yaw, 1.0, d = (TupleDesc)descs.grow())) {
                    locs.add(pt.copy());
                    continue;
                }
                descs.removeTail();
            }
        }
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage left = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(0));
        BufferedImage right = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(1));
        this.process(left, right);
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        VisualizeAssociationMatchesApp app = new VisualizeAssociationMatchesApp(imageType, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Cave", UtilIO.pathExample("stitch/cave_01.jpg"), UtilIO.pathExample("stitch/cave_02.jpg")));
        inputs.add(new PathLabel("Kayak", UtilIO.pathExample("stitch/kayak_02.jpg"), UtilIO.pathExample("stitch/kayak_03.jpg")));
        inputs.add(new PathLabel("Forest", UtilIO.pathExample("scale/rainforest_01.jpg"), UtilIO.pathExample("scale/rainforest_02.jpg")));
        inputs.add(new PathLabel("Building", UtilIO.pathExample("stitch/apartment_building_01.jpg"), UtilIO.pathExample("stitch/apartment_building_02.jpg")));
        inputs.add(new PathLabel("Trees Rotate", UtilIO.pathExample("stitch/trees_rotate_01.jpg"), UtilIO.pathExample("stitch/trees_rotate_03.jpg")));
        app.setPreferredSize(new Dimension(1000, 500));
        app.setSize(1000, 500);
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Associated Features", true);
    }
}

