/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.denoise;

import boofcv.abst.denoise.WaveletDenoiseFilter;
import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.GPixelMath;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.denoise.DenoiseInfoPanel;
import boofcv.factory.denoise.FactoryDenoiseWaveletAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.transform.wavelet.FactoryWaveletCoiflet;
import boofcv.factory.transform.wavelet.FactoryWaveletDaub;
import boofcv.factory.transform.wavelet.FactoryWaveletHaar;
import boofcv.factory.transform.wavelet.FactoryWaveletTransform;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DenoiseVisualizeApp<T extends ImageGray, D extends ImageGray, W extends WlCoef>
extends SelectAlgorithmAndInputPanel
implements DenoiseInfoPanel.Listener {
    float noiseSigma;
    int numLevels;
    int blurRadius;
    Random rand = new Random(2234L);
    BlurFilter<T> filter;
    DenoiseWavelet<T> denoiser;
    WaveletDescription<W> waveletDesc;
    List<WaveletDescription> waveletList = new ArrayList<WaveletDescription>();
    JPanel gui = new JPanel();
    DenoiseInfoPanel info = new DenoiseInfoPanel();
    ImagePanel imagePanel = new ImagePanel();
    Class<T> imageType;
    T input;
    T noisy;
    T output;
    D deriv;
    Vector<BufferedImage> images = new Vector();
    boolean processedImage = false;

    public DenoiseVisualizeApp(Class<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "BayesShrink", FactoryDenoiseWaveletAlg.bayes(null, imageType));
        this.addAlgorithm(0, "SureShrink", FactoryDenoiseWaveletAlg.sure(imageType));
        this.addAlgorithm(0, "VisuShrink", FactoryDenoiseWaveletAlg.visu(imageType));
        BlurStorageFilter<T> filter = FactoryBlurFilter.gaussian(imageType, -1.0, 1);
        this.addAlgorithm(0, "Gaussian", filter);
        filter = FactoryBlurFilter.mean(imageType, 1);
        this.addAlgorithm(0, "Mean", filter);
        filter = FactoryBlurFilter.median(imageType, 1);
        this.addAlgorithm(0, "Median", filter);
        this.info.addWaveletName("Daub 4");
        this.waveletList.add(FactoryWaveletDaub.daubJ_F32(4));
        this.info.addWaveletName("Coiflet 6");
        this.waveletList.add(FactoryWaveletCoiflet.generate_F32(6));
        this.info.addWaveletName("Haar");
        this.waveletList.add(FactoryWaveletHaar.generate(false, 32));
        this.waveletDesc = this.waveletList.get(0);
        this.input = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.noisy = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.output = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.deriv = GeneralizedImageOps.createSingleBand(derivType, 1, 1);
        this.gui.setLayout(new BorderLayout());
        this.gui.add((Component)this.info, "West");
        this.gui.add((Component)this.imagePanel, "Center");
        this.info.setListener(this);
        this.noiseSigma = this.info.getNoiseSigma();
        this.blurRadius = this.info.getBlurRadius();
        this.numLevels = this.info.getWaveletLevel();
        this.setMainGUI(this.gui);
    }

    public void process(BufferedImage image) {
        ((ImageGray)this.input).reshape(image.getWidth(), image.getHeight());
        ((ImageGray)this.noisy).reshape(((ImageGray)this.input).width, ((ImageGray)this.input).height);
        ((ImageGray)this.output).reshape(((ImageGray)this.input).width, ((ImageGray)this.input).height);
        ((ImageGray)this.deriv).reshape(((ImageGray)this.input).width, ((ImageGray)this.input).height);
        ConvertBufferedImage.convertFromSingle(image, this.input, this.imageType);
        ((ImageGray)this.noisy).setTo(this.input);
        GImageMiscOps.addGaussian(this.noisy, this.rand, this.noiseSigma, 0.0, 255.0);
        GPixelMath.boundImage(this.noisy, 0.0, 255.0);
        GImageDerivativeOps.laplace(this.input, this.deriv);
        GPixelMath.abs(this.deriv, this.deriv);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DenoiseVisualizeApp.this.images.clear();
                DenoiseVisualizeApp.this.images.add(ConvertBufferedImage.convertTo(DenoiseVisualizeApp.this.output, null, true));
                DenoiseVisualizeApp.this.images.add(ConvertBufferedImage.convertTo(DenoiseVisualizeApp.this.noisy, null, true));
                DenoiseVisualizeApp.this.images.add(ConvertBufferedImage.convertTo(DenoiseVisualizeApp.this.input, null, true));
                DenoiseVisualizeApp.this.info.reset();
                DenoiseVisualizeApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        if (cookies[0] instanceof DenoiseWavelet) {
            this.denoiser = (DenoiseWavelet)cookies[0];
            this.filter = null;
        } else {
            this.denoiser = null;
            this.filter = (BlurFilter)cookies[0];
        }
        this.performDenoising();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        switch (indexFamily) {
            case 0: {
                if (cookie instanceof DenoiseWavelet) {
                    this.denoiser = (DenoiseWavelet)cookie;
                    this.filter = null;
                    break;
                }
                this.filter = (BlurFilter)cookie;
                this.denoiser = null;
            }
        }
        this.performDenoising();
    }

    private synchronized void performDenoising() {
        if (this.denoiser != null) {
            WaveletTransform waveletTran = FactoryWaveletTransform.create(this.imageType, this.waveletDesc, this.numLevels, 0.0, 255.0);
            WaveletDenoiseFilter<T> filter = new WaveletDenoiseFilter<T>(waveletTran, this.denoiser);
            filter.process(this.noisy, this.output);
        } else {
            this.filter.setRadius(this.blurRadius);
            this.filter.process(this.noisy, this.output);
        }
        final double algError = DenoiseVisualizeApp.computeError((GrayF32)this.output, (GrayF32)this.input);
        final double algErrorEdge = DenoiseVisualizeApp.computeWeightedError((GrayF32)this.output, (GrayF32)this.input, (GrayF32)this.deriv);
        final double noiseError = DenoiseVisualizeApp.computeError((GrayF32)this.noisy, (GrayF32)this.input);
        final double noiseErrorEdge = DenoiseVisualizeApp.computeWeightedError((GrayF32)this.noisy, (GrayF32)this.input, (GrayF32)this.deriv);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DenoiseVisualizeApp.this.info.setWaveletActive(DenoiseVisualizeApp.this.denoiser != null);
                ConvertBufferedImage.convertTo(DenoiseVisualizeApp.this.output, DenoiseVisualizeApp.this.images.get(0), true);
                ConvertBufferedImage.convertTo(DenoiseVisualizeApp.this.noisy, DenoiseVisualizeApp.this.images.get(1), true);
                DenoiseVisualizeApp.this.info.setError(algError, algErrorEdge, noiseError, noiseErrorEdge);
                DenoiseVisualizeApp.this.imagePanel.repaint();
                DenoiseVisualizeApp.this.info.repaint();
                DenoiseVisualizeApp.this.processedImage = true;
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public void noiseChange(float sigma) {
        this.noiseSigma = sigma;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ImageGray)DenoiseVisualizeApp.this.noisy).setTo(DenoiseVisualizeApp.this.input);
                GImageMiscOps.addGaussian(DenoiseVisualizeApp.this.noisy, DenoiseVisualizeApp.this.rand, DenoiseVisualizeApp.this.noiseSigma, 0.0, 255.0);
                GPixelMath.boundImage(DenoiseVisualizeApp.this.noisy, 0.0, 255.0);
                DenoiseVisualizeApp.this.performDenoising();
            }
        });
    }

    @Override
    public void imageChange(final int which) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BufferedImage b = DenoiseVisualizeApp.this.images.get(which);
                DenoiseVisualizeApp.this.imagePanel.setBufferedImage(DenoiseVisualizeApp.this.images.get(which));
                DenoiseVisualizeApp.this.imagePanel.setPreferredSize(new Dimension(b.getWidth(), b.getHeight()));
                DenoiseVisualizeApp.this.gui.validate();
                DenoiseVisualizeApp.this.imagePanel.repaint();
            }
        });
    }

    @Override
    public void waveletChange(int which, int level) {
        this.waveletDesc = this.waveletList.get(which);
        this.numLevels = level;
        this.performDenoising();
    }

    @Override
    public void noiseChange(int radius) {
        this.blurRadius = radius;
        this.performDenoising();
    }

    public static double computeError(GrayF32 imgA, GrayF32 imgB) {
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        double total = 0.0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                double difference = Math.abs(imgA.get(x, y) - imgB.get(x, y));
                total += difference;
            }
        }
        return total / (double)(w * h);
    }

    public static double computeWeightedError(GrayF32 imgA, GrayF32 imgB, GrayF32 imgWeight) {
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        double total = 0.0;
        double totalWeight = 0.0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float weight = imgWeight.get(x, y);
                double difference = Math.abs(imgA.get(x, y) - imgB.get(x, y));
                total += difference * (double)weight;
                totalWeight += (double)weight;
            }
        }
        return total / totalWeight;
    }

    public static void main(String[] args) {
        DenoiseVisualizeApp app = new DenoiseVisualizeApp(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("lena", UtilIO.pathExample("standard/lena512.jpg")));
        inputs.add(new PathLabel("barbara", UtilIO.pathExample("standard/barbara.jpg")));
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("fingerprint", UtilIO.pathExample("standard/fingerprint.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Noise Removal", true);
        System.out.println("Done");
    }
}

