/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.denoise;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.demonstrations.denoise.DenoiseAccuracyStudyApp;
import boofcv.misc.Performer;
import boofcv.misc.ProfileOperation;
import boofcv.struct.image.GrayF32;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class DenoiseSpeedStudyApp {
    long TEST_TIME = 1000L;
    int width = 640;
    int height = 480;
    Random rand = new Random(2234L);
    GrayF32 image = new GrayF32(this.width, this.height);
    GrayF32 imageDenoised = new GrayF32(this.width, this.height);

    public void process(List<DenoiseAccuracyStudyApp.TestItem> filters) {
        ImageMiscOps.fillUniform(this.image, this.rand, 0.0f, 20.0f);
        for (DenoiseAccuracyStudyApp.TestItem i : filters) {
            System.out.print("-");
        }
        System.out.println();
        for (DenoiseAccuracyStudyApp.TestItem i : filters) {
            System.out.print("*");
            i.opsPerSecond = ProfileOperation.profileOpsPerSec(new RunFilter(i), this.TEST_TIME, false);
        }
        System.out.println();
        Collections.sort(filters, new Comparator<DenoiseAccuracyStudyApp.TestItem>(){

            @Override
            public int compare(DenoiseAccuracyStudyApp.TestItem o1, DenoiseAccuracyStudyApp.TestItem o2) {
                if (o1.opsPerSecond < o2.opsPerSecond) {
                    return -1;
                }
                if (o1.opsPerSecond > o2.opsPerSecond) {
                    return 1;
                }
                return 0;
            }
        });
        for (DenoiseAccuracyStudyApp.TestItem i : filters) {
            System.out.printf("%30s  ops/sec = %6.2f\n", i.name, i.opsPerSecond);
        }
    }

    public static void main(String[] args) {
        DenoiseSpeedStudyApp app = new DenoiseSpeedStudyApp();
        app.process(DenoiseAccuracyStudyApp.createStandard(2, 4));
    }

    public class RunFilter
    implements Performer {
        public DenoiseAccuracyStudyApp.TestItem item;

        public RunFilter(DenoiseAccuracyStudyApp.TestItem item) {
            this.item = item;
        }

        @Override
        public void process() {
            this.item.filter.process(DenoiseSpeedStudyApp.this.image, DenoiseSpeedStudyApp.this.imageDenoised);
        }

        @Override
        public String getName() {
            return this.item.name;
        }
    }
}

