/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.color;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.color.ColorLab;
import boofcv.alg.color.ColorXyz;
import boofcv.alg.color.ColorYuv;
import boofcv.alg.misc.PixelMath;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ShowColorModelApp
extends SelectAlgorithmAndInputPanel {
    int active = 0;
    ListDisplayPanel gui = new ListDisplayPanel();
    boolean processedImage = false;
    Planar<GrayF32> input;
    Planar<GrayF32> output;
    volatile int progress;

    public ShowColorModelApp() {
        super(1);
        this.addAlgorithm(0, "RGB", 0);
        this.addAlgorithm(0, "HSV", 1);
        this.addAlgorithm(0, "YUV", 2);
        this.addAlgorithm(0, "XYZ", 3);
        this.addAlgorithm(0, "LAB", 4);
        this.input = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        this.output = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
        this.setMainGUI(this.gui);
    }

    public void process(final BufferedImage image) {
        this.input.reshape(image.getWidth(), image.getHeight());
        this.output.reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromMulti(image, this.input, true, GrayF32.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowColorModelApp.this.setInputImage(image);
                ShowColorModelApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.active = (Integer)cookie;
        this.performUpdate();
    }

    private synchronized void performUpdate() {
        if (this.input == null || this.output == null) {
            return;
        }
        this.progress = 0;
        MyMonitor monitor = new MyMonitor(this, "");
        monitor.start();
        final String[] names = new String[3];
        final BufferedImage[] out = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            out[i] = new BufferedImage(this.input.width, this.input.height, 1);
        }
        switch (this.active) {
            case 0: {
                names[0] = "Red";
                names[1] = "Green";
                names[2] = "Blue";
                this.output.setTo(this.input);
                ConvertBufferedImage.convertTo(this.output.getBand(0), out[0]);
                ConvertBufferedImage.convertTo(this.output.getBand(1), out[1]);
                ConvertBufferedImage.convertTo(this.output.getBand(2), out[2]);
                break;
            }
            case 1: {
                names[0] = "Hue";
                names[1] = "Saturation";
                names[2] = "Value";
                ColorHsv.rgbToHsv_F32(this.input, this.output);
                this.setNaN(this.output.getBand(0));
                PixelMath.multiply(this.output.getBand(0), 40.58451f, this.output.getBand(0));
                PixelMath.multiply(this.output.getBand(1), 255.0f, this.output.getBand(1));
                ConvertBufferedImage.convertTo(this.output.getBand(0), out[0]);
                ConvertBufferedImage.convertTo(this.output.getBand(1), out[1]);
                ConvertBufferedImage.convertTo(this.output.getBand(2), out[2]);
                break;
            }
            case 2: {
                names[0] = "Y";
                names[1] = "U";
                names[2] = "V";
                ColorYuv.rgbToYuv_F32(this.input, this.output);
                ConvertBufferedImage.convertTo(this.output.getBand(0), out[0]);
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(1), out[1], -1.0);
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(2), out[2], -1.0);
                break;
            }
            case 3: {
                names[0] = "X";
                names[1] = "Y";
                names[2] = "Z";
                ColorXyz.rgbToXyz_F32(this.input, this.output);
                PixelMath.multiply(this.output.getBand(1), 255.0f, this.output.getBand(1));
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(0), out[0], -1.0);
                ConvertBufferedImage.convertTo(this.output.getBand(1), out[1]);
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(2), out[2], -1.0);
                break;
            }
            case 4: {
                names[0] = "L";
                names[1] = "A";
                names[2] = "B";
                ColorLab.rgbToLab_F32(this.input, this.output);
                VisualizeImageData.grayMagnitude((ImageGray)this.output.getBand(0), out[0], -1.0);
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(1), out[1], -1.0);
                VisualizeImageData.colorizeSign((ImageGray)this.output.getBand(2), out[2], -1.0);
            }
        }
        monitor.stopThread();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowColorModelApp.this.gui.reset();
                for (int i = 0; i < 3; ++i) {
                    ShowColorModelApp.this.gui.addImage(out[i], names[i]);
                }
                ShowColorModelApp.this.gui.setPreferredSize(new Dimension(ShowColorModelApp.this.input.width, ShowColorModelApp.this.input.height));
                ShowColorModelApp.this.gui.repaint();
                ShowColorModelApp.this.processedImage = true;
            }
        });
    }

    private void setNaN(GrayF32 image) {
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float v = image.unsafe_get(x, y);
                if (!Float.isNaN(v) && !Float.isInfinite(v)) continue;
                image.unsafe_set(x, y, 0.0f);
            }
        }
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        } else {
            System.err.println("Can't open " + ((PathLabel)this.inputRefs.get(index)).getPath());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        ShowColorModelApp app = new ShowColorModelApp();
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Color Formats", true);
    }

    private class MyMonitor
    extends ProgressMonitorThread {
        protected MyMonitor(Component comp, String message) {
            super(new ProgressMonitor(comp, "Converting color space", message, 0, ShowColorModelApp.this.input.getNumBands()));
        }

        @Override
        public void doRun() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMonitor.this.monitor.setProgress(ShowColorModelApp.this.progress);
                }
            });
        }
    }
}

