/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.calibration.CalibratedImageGridPanel;
import boofcv.struct.calib.IntrinsicParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ejml.data.DenseMatrix64F;

public class StereoPlanarPanel
extends JPanel
implements ListSelectionListener,
ItemListener,
ChangeListener,
MouseListener {
    CalibratedImageGridPanel leftView = new CalibratedImageGridPanel();
    CalibratedImageGridPanel rightView = new CalibratedImageGridPanel();
    List<BufferedImage> listLeft = new ArrayList<BufferedImage>();
    List<BufferedImage> listRight = new ArrayList<BufferedImage>();
    List<ImageResults> leftResults;
    List<ImageResults> rightResults;
    JCheckBox checkPoints;
    JCheckBox checkErrors;
    JCheckBox checkUndistorted;
    JCheckBox checkAll;
    JCheckBox checkNumbers;
    JSpinner selectErrorScale;
    JTextArea meanErrorLeft;
    JTextArea maxErrorLeft;
    JTextArea meanErrorRight;
    JTextArea maxErrorRight;
    JList imageList;
    List<String> names = new ArrayList<String>();
    int selectedImage;
    boolean showPoints = true;
    boolean showErrors = true;
    boolean showUndistorted = false;
    boolean showAll = false;
    boolean showNumbers = true;
    double errorScale = 20.0;

    public StereoPlanarPanel() {
        super(new BorderLayout());
        this.leftView.setImages(this.listLeft);
        this.rightView.setImages(this.listRight);
        this.imageList = new JList();
        this.imageList.setSelectionMode(0);
        this.imageList.addListSelectionListener(this);
        this.meanErrorLeft = this.createTextComponent();
        this.maxErrorLeft = this.createTextComponent();
        this.meanErrorRight = this.createTextComponent();
        this.maxErrorRight = this.createTextComponent();
        this.leftView.addMouseListener(this);
        this.rightView.addMouseListener(this);
        JToolBar toolBar = this.createToolBar();
        JPanel center = new JPanel();
        center.setLayout(new GridLayout(1, 2));
        center.add(this.leftView);
        center.add(this.rightView);
        this.add((Component)toolBar, "First");
        this.add((Component)center, "Center");
        this.add((Component)new SideBar(), "West");
    }

    private JTextArea createTextComponent() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar("Controls");
        this.checkPoints = new JCheckBox("Show Points");
        this.checkPoints.setSelected(this.showPoints);
        this.checkPoints.addItemListener(this);
        this.checkErrors = new JCheckBox("Show Errors");
        this.checkErrors.setSelected(this.showErrors);
        this.checkErrors.addItemListener(this);
        this.checkAll = new JCheckBox("All Points");
        this.checkAll.setSelected(this.showAll);
        this.checkAll.addItemListener(this);
        this.checkUndistorted = new JCheckBox("Rectify");
        this.checkUndistorted.setSelected(this.showUndistorted);
        this.checkUndistorted.addItemListener(this);
        this.checkUndistorted.setEnabled(false);
        this.checkNumbers = new JCheckBox("Numbers");
        this.checkNumbers.setSelected(this.showNumbers);
        this.checkNumbers.addItemListener(this);
        this.selectErrorScale = new JSpinner(new SpinnerNumberModel(this.errorScale, 5.0, 100.0, 5.0));
        this.selectErrorScale.addChangeListener(this);
        this.selectErrorScale.setMaximumSize(this.selectErrorScale.getPreferredSize());
        toolBar.add(this.checkPoints);
        toolBar.add(this.checkErrors);
        toolBar.add(this.checkAll);
        toolBar.add(this.checkUndistorted);
        toolBar.add(this.checkNumbers);
        toolBar.add(new JLabel("| Error Scale"));
        toolBar.add(this.selectErrorScale);
        return toolBar;
    }

    public void setRectification(IntrinsicParameters leftParam, DenseMatrix64F leftRect, IntrinsicParameters rightParam, DenseMatrix64F rightRect) {
        this.leftView.setDistorted(leftParam, leftRect);
        this.rightView.setDistorted(rightParam, rightRect);
        this.checkUndistorted.setEnabled(true);
    }

    public void addPair(String name, BufferedImage imageLeft, BufferedImage imageRight) {
        this.listLeft.add(imageLeft);
        this.listRight.add(imageRight);
        this.names.add(name);
        this.imageList.removeListSelectionListener(this);
        this.imageList.setListData(new Vector<String>(this.names));
        if (this.names.size() == 1) {
            this.imageList.addListSelectionListener(this);
            this.leftView.setPreferredSize(new Dimension(imageLeft.getWidth(), imageLeft.getHeight()));
            this.rightView.setPreferredSize(new Dimension(imageRight.getWidth(), imageRight.getHeight()));
            this.imageList.setSelectedIndex(0);
        } else {
            this.imageList.addListSelectionListener(this);
        }
        this.validate();
    }

    public synchronized void setObservations(List<CalibrationObservation> leftObservations, List<ImageResults> leftResults, List<CalibrationObservation> rightObservations, List<ImageResults> rightResults) {
        this.leftView.setResults(leftObservations, leftResults);
        this.rightView.setResults(rightObservations, rightResults);
        this.leftResults = leftResults;
        this.rightResults = rightResults;
        this.leftView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.rightView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.updateResultsGUI();
    }

    protected void setSelected(int selected) {
        this.selectedImage = selected;
        this.leftView.setSelected(selected);
        this.rightView.setSelected(selected);
        this.updateResultsGUI();
    }

    private synchronized void updateResultsGUI() {
        if (this.leftResults != null && this.rightResults != null && this.selectedImage < this.leftResults.size()) {
            ImageResults r = this.leftResults.get(this.selectedImage);
            String textMean = String.format("%5.1e", r.meanError);
            String textMax = String.format("%5.1e", r.maxError);
            this.meanErrorLeft.setText(textMean);
            this.maxErrorLeft.setText(textMax);
            r = this.rightResults.get(this.selectedImage);
            textMean = String.format("%5.1e", r.meanError);
            textMax = String.format("%5.1e", r.maxError);
            this.meanErrorRight.setText(textMean);
            this.maxErrorRight.setText(textMax);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPoints) {
            this.showPoints = this.checkPoints.isSelected();
        } else if (e.getSource() == this.checkErrors) {
            this.showErrors = this.checkErrors.isSelected();
        } else if (e.getSource() == this.checkAll) {
            this.showAll = this.checkAll.isSelected();
        } else if (e.getSource() == this.checkUndistorted) {
            this.showUndistorted = this.checkUndistorted.isSelected();
        } else if (e.getSource() == this.checkNumbers) {
            this.showNumbers = this.checkNumbers.isSelected();
        }
        this.leftView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.rightView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.leftView.repaint();
        this.rightView.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || e.getFirstIndex() == -1) {
            return;
        }
        if (this.imageList.getSelectedIndex() >= 0) {
            this.setSelected(this.imageList.getSelectedIndex());
            this.leftView.repaint();
            this.rightView.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectErrorScale) {
            this.errorScale = ((Number)this.selectErrorScale.getValue()).intValue();
        }
        this.leftView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.rightView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.errorScale);
        this.leftView.repaint();
        this.rightView.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.leftView.setLine(e.getY());
        this.rightView.setLine(e.getY());
        this.leftView.repaint();
        this.rightView.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class SideBar
    extends StandardAlgConfigPanel {
        public SideBar() {
            JScrollPane scroll = new JScrollPane(StereoPlanarPanel.this.imageList);
            this.addCenterLabel("Left", this);
            this.addLabeled(StereoPlanarPanel.this.meanErrorLeft, "Mean Error", this);
            this.addLabeled(StereoPlanarPanel.this.maxErrorLeft, "Max Error", this);
            this.addSeparator(200);
            this.addCenterLabel("Right", this);
            this.addLabeled(StereoPlanarPanel.this.meanErrorRight, "Mean Error", this);
            this.addLabeled(StereoPlanarPanel.this.maxErrorRight, "Max Error", this);
            this.addSeparator(200);
            this.add(scroll);
        }
    }
}

