/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.filter.binary.Contour;
import boofcv.demonstrations.calibration.ChessboardPanel;
import boofcv.gui.DemonstrationBase;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.fiducial.VisualizeFiducial;
import boofcv.gui.image.ImageZoomPanel;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.FastQueue;

public abstract class CommonDetectCalibrationApp
extends DemonstrationBase<GrayF32>
implements ChessboardPanel.Listener {
    boolean success;
    ChessboardPanel controlPanel;
    VisualizePanel imagePanel = new VisualizePanel();
    BufferedImage input;
    BufferedImage binary;
    GrayF32 grayPrev = new GrayF32(1, 1);

    public CommonDetectCalibrationApp(int numRows, int numColumns, List<String> exampleInputs) {
        super(exampleInputs, ImageType.single(GrayF32.class));
        this.controlPanel = new ChessboardPanel(numRows, numColumns, true);
        this.add((Component)this.imagePanel, "Center");
        this.add((Component)this.controlPanel, "West");
        this.controlPanel.setListener(this);
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                double scale = CommonDetectCalibrationApp.this.imagePanel.getScale();
                System.out.println("clicked at " + (double)e.getX() / scale + " " + (double)e.getY() / scale);
            }
        });
        this.imagePanel.addMouseWheelListener(this.controlPanel);
    }

    protected abstract void declareDetector();

    protected abstract boolean process(GrayF32 var1);

    protected abstract GrayU8 getBinaryImage();

    protected abstract List<List<SquareNode>> getClusters();

    protected abstract List<Point2D_F64> getCalibrationPoints();

    protected abstract List<Contour> getContours();

    protected abstract FastQueue<Polygon2D_F64> getFoundPolygons();

    protected abstract List<SquareGrid> getGrids();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processImage(BufferedImage buffered, GrayF32 gray) {
        this.input = buffered;
        CommonDetectCalibrationApp commonDetectCalibrationApp = this;
        synchronized (commonDetectCalibrationApp) {
            this.binary = CommonDetectCalibrationApp.conditionalDeclare(buffered, this.binary, 1);
            this.grayPrev.setTo(gray);
        }
        this.processFrame();
    }

    private void renderGraph(Graphics2D g2, double scale) {
        List<List<SquareNode>> graphs = this.getClusters();
        BasicStroke strokeWide = new BasicStroke(3.0f);
        BasicStroke strokeNarrow = new BasicStroke(2.0f);
        Line2D.Double l = new Line2D.Double();
        g2.setStroke(new BasicStroke(3.0f));
        for (int i = 0; i < graphs.size(); ++i) {
            List<SquareNode> graph = graphs.get(i);
            int key = graphs.size() == 1 ? 0 : 255 * i / (graphs.size() - 1);
            int rgb = key << 8 | 255 - key;
            g2.setColor(new Color(rgb));
            ArrayList<SquareEdge> edges = new ArrayList<SquareEdge>();
            for (SquareNode n : graph) {
                for (int j = 0; j < n.edges.length; ++j) {
                    if (n.edges[j] == null || edges.contains(n.edges[j])) continue;
                    edges.add(n.edges[j]);
                }
            }
            for (SquareEdge e : edges) {
                Point2D_F64 a = e.a.center;
                Point2D_F64 b = e.b.center;
                l.setLine(a.x * scale, a.y * scale, b.x * scale, b.y * scale);
                g2.setColor(Color.CYAN);
                g2.setStroke(strokeWide);
                g2.draw(l);
                g2.setColor(new Color(rgb));
                g2.setStroke(strokeNarrow);
                g2.draw(l);
            }
        }
    }

    @Override
    public void calibEventGUI() {
        if (this.controlPanel.getSelectedView() == 0) {
            this.imagePanel.setBufferedImage(this.input);
        } else if (this.controlPanel.getSelectedView() == 1) {
            this.imagePanel.setBufferedImage(this.binary);
        } else {
            throw new RuntimeException("Unknown");
        }
        this.imagePanel.setScale(this.controlPanel.getScale());
        this.imagePanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calibEventDetectorModified() {
        CommonDetectCalibrationApp commonDetectCalibrationApp = this;
        synchronized (commonDetectCalibrationApp) {
            this.declareDetector();
        }
        this.processFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFrame() {
        CommonDetectCalibrationApp commonDetectCalibrationApp = this;
        synchronized (commonDetectCalibrationApp) {
            this.success = this.process(this.grayPrev);
            VisualizeBinaryData.renderBinary(this.getBinaryImage(), false, this.binary);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CommonDetectCalibrationApp.this.success) {
                    CommonDetectCalibrationApp.this.controlPanel.setSuccessMessage("FOUND", true);
                } else {
                    CommonDetectCalibrationApp.this.controlPanel.setSuccessMessage("FAILED", false);
                }
                CommonDetectCalibrationApp.this.imagePanel.setPreferredSize(new Dimension(CommonDetectCalibrationApp.this.input.getWidth() + 5, CommonDetectCalibrationApp.this.input.getHeight() + 5));
                CommonDetectCalibrationApp.this.calibEventGUI();
                CommonDetectCalibrationApp.this.imagePanel.repaint();
            }
        });
    }

    private void renderOrder(Graphics2D g2, double scale) {
        List<SquareGrid> grids = this.getGrids();
        g2.setStroke(new BasicStroke(3.0f));
        Line2D.Double l = new Line2D.Double();
        for (int i = 0; i < grids.size(); ++i) {
            SquareGrid g = grids.get(i);
            SquareNode p0 = null;
            for (int j = 0; j < g.nodes.size(); ++j) {
                SquareNode p1 = g.nodes.get(j);
                if (p1 == null) continue;
                if (p0 != null) {
                    double fraction = (double)j / ((double)g.nodes.size() - 1.0);
                    fraction = fraction * 0.8 + 0.1;
                    int red = (int)(255.0 * fraction) + (int)(16.0 * (1.0 - fraction));
                    int green = (int)(0.0 * fraction) + (int)(0.0 * (1.0 - fraction));
                    int blue = (int)(16.0 * fraction) + (int)(255.0 * (1.0 - fraction));
                    int lineRGB = red << 16 | green << 8 | blue;
                    l.setLine(scale * p0.center.x, scale * p0.center.y, scale * p1.center.x, scale * p1.center.y);
                    g2.setColor(new Color(lineRGB));
                    g2.draw(l);
                }
                p0 = p1;
            }
        }
    }

    public static void drawPolygon(Polygon2D_F64 polygon, Graphics2D g2, double scale) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double l = new Line2D.Double();
        for (int i = 0; i < polygon.size() - 1; ++i) {
            Point2D_F64 p0 = polygon.get(i);
            Point2D_F64 p1 = polygon.get(i + 1);
            VisualizeFiducial.drawLine(g2, l, p0.x * scale, p0.y * scale, p1.x * scale, p1.y * scale);
        }
        if (polygon.size() > 0) {
            Point2D_F64 p0 = polygon.get(0);
            Point2D_F64 p1 = polygon.get(polygon.size() - 1);
            VisualizeFiducial.drawLine(g2, l, p0.x * scale, p0.y * scale, p1.x * scale, p1.y * scale);
        }
    }

    private boolean isInGrids(Polygon2D_F64 p) {
        List<SquareGrid> grids = this.getGrids();
        for (int i = 0; i < grids.size(); ++i) {
            SquareGrid g = grids.get(i);
            for (int j = 0; j < g.nodes.size(); ++j) {
                if (g.nodes.get(j) == null || g.nodes.get((int)j).corners != p) continue;
                return true;
            }
        }
        return false;
    }

    private void drawCornersInside(Graphics2D g2, double scale, Polygon2D_F64 poly) {
        Color[] colors = new Color[]{Color.RED, new Color(190, 0, 0), Color.GREEN, new Color(0, 190, 0)};
        Point2D_F64 center = new Point2D_F64();
        UtilPolygons2D_F64.vertexAverage((Polygon2D_F64)poly, (Point2D_F64)center);
        for (int i = 0; i < poly.size(); ++i) {
            Point2D_F64 p = poly.get(i);
            Color c = i < 4 ? colors[i] : Color.BLUE;
            double dx = p.x - center.x;
            double dy = p.y - center.y;
            double x = (center.x + dx * 0.75) * scale;
            double y = (center.y + dy * 0.75) * scale;
            VisualizeFeatures.drawPoint(g2, x, y, 3.0, c, false);
        }
    }

    public static void drawNumbers(Graphics2D g2, List<Point2D_F64> foundTarget, PointTransform_F32 transform, double scale) {
        Font regular = new Font("Serif", 0, 16);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < foundTarget.size(); ++i) {
            Point2D_F64 p = foundTarget.get(i);
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.set((float)p.x, (float)p.y);
            }
            String text = String.format("%2d", i);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    class VisualizePanel
    extends ImageZoomPanel {
        VisualizePanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            CommonDetectCalibrationApp commonDetectCalibrationApp = CommonDetectCalibrationApp.this;
            synchronized (commonDetectCalibrationApp) {
                if (CommonDetectCalibrationApp.this.success) {
                    if (CommonDetectCalibrationApp.this.controlPanel.isShowPoints()) {
                        List<Point2D_F64> candidates = CommonDetectCalibrationApp.this.getCalibrationPoints();
                        for (Point2D_F64 c : candidates) {
                            VisualizeFeatures.drawPoint(g2, (int)(this.scale * c.x + 0.5), (int)(this.scale * c.y + 0.5), 1, Color.RED);
                        }
                    }
                    if (CommonDetectCalibrationApp.this.controlPanel.isShowNumbers()) {
                        CommonDetectCalibrationApp.drawNumbers(g2, CommonDetectCalibrationApp.this.getCalibrationPoints(), null, this.scale);
                    }
                }
                if (CommonDetectCalibrationApp.this.controlPanel.doShowContour) {
                    List<Contour> contour = CommonDetectCalibrationApp.this.getContours();
                    g2.setStroke(new BasicStroke(1.0f));
                    g2.setColor(Color.RED);
                    VisualizeBinaryData.renderExternal(contour, false, true, this.scale, g2);
                }
                if (CommonDetectCalibrationApp.this.controlPanel.isShowGraph()) {
                    CommonDetectCalibrationApp.this.renderGraph(g2, this.scale);
                }
                if (CommonDetectCalibrationApp.this.controlPanel.isShowOrder()) {
                    CommonDetectCalibrationApp.this.renderOrder(g2, this.scale);
                }
                if (CommonDetectCalibrationApp.this.controlPanel.isShowSquares()) {
                    FastQueue<Polygon2D_F64> squares = CommonDetectCalibrationApp.this.getFoundPolygons();
                    for (int i = 0; i < squares.size(); ++i) {
                        Polygon2D_F64 p = (Polygon2D_F64)squares.get(i);
                        if (CommonDetectCalibrationApp.this.isInGrids(p)) continue;
                        g2.setColor(Color.cyan);
                        g2.setStroke(new BasicStroke(4.0f));
                        CommonDetectCalibrationApp.drawPolygon(p, g2, this.scale);
                        g2.setColor(Color.blue);
                        g2.setStroke(new BasicStroke(2.0f));
                        CommonDetectCalibrationApp.drawPolygon(p, g2, this.scale);
                        CommonDetectCalibrationApp.this.drawCornersInside(g2, this.scale, p);
                    }
                }
                if (CommonDetectCalibrationApp.this.controlPanel.isShowGrids()) {
                    List<SquareGrid> grids = CommonDetectCalibrationApp.this.getGrids();
                    for (int i = 0; i < grids.size(); ++i) {
                        SquareGrid g = grids.get(i);
                        int a = grids.size() == 1 ? 0 : 255 * i / (grids.size() - 1);
                        int rgb = a << 16 | 255 - a << 8;
                        g2.setStroke(new BasicStroke(3.0f));
                        Color color = new Color(rgb);
                        for (int j = 0; j < g.nodes.size(); ++j) {
                            SquareNode n = g.nodes.get(j);
                            if (n == null) continue;
                            g2.setColor(color);
                            VisualizeShapes.drawPolygon(n.corners, true, this.scale, g2);
                            CommonDetectCalibrationApp.this.drawCornersInside(g2, this.scale, n.corners);
                        }
                    }
                }
            }
        }
    }
}

