/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChessboardPanel
extends StandardAlgConfigPanel
implements ChangeListener,
ItemListener,
MouseWheelListener {
    private static double ZOOM_MAX = 20.0;
    private static double ZOOM_MIN = 0.1;
    private static double ZOOM_INC = 0.1;
    JLabel successIndicator;
    JSpinner selectRows;
    JSpinner selectColumns;
    JComboBox viewSelector;
    JCheckBox showPoints;
    JCheckBox showNumbers;
    JCheckBox showGraph;
    JCheckBox showGrids;
    JCheckBox showSquares;
    JCheckBox showOrder;
    JCheckBox showContour;
    JSpinner selectZoom;
    JSpinner thresholdSpinner;
    JCheckBox manualThreshold;
    boolean doShowPoints = true;
    boolean doShowNumbers = true;
    boolean doShowGraph = false;
    boolean doShowOrder = false;
    boolean doShowGrids = false;
    boolean doShowSquares = false;
    boolean doShowContour = false;
    double scale = 1.0;
    boolean isManual = false;
    int gridRows;
    int gridColumns;
    Listener listener;
    int selectedView = 0;
    int thresholdLevel = 60;

    public ChessboardPanel(int gridRows, int gridColumns, boolean hasManualMode) {
        this.gridRows = gridRows;
        this.gridColumns = gridColumns;
        this.viewSelector = new JComboBox();
        this.viewSelector.addItem("Original");
        this.viewSelector.addItem("Threshold");
        this.viewSelector.addItemListener(this);
        this.viewSelector.setMaximumSize(this.viewSelector.getPreferredSize());
        this.selectZoom = new JSpinner(new SpinnerNumberModel(1.0, ZOOM_MIN, ZOOM_MAX, ZOOM_INC));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.successIndicator = new JLabel();
        this.showPoints = new JCheckBox("Show Points");
        this.showPoints.setSelected(this.doShowPoints);
        this.showPoints.addItemListener(this);
        this.showPoints.setMaximumSize(this.showPoints.getPreferredSize());
        this.showNumbers = new JCheckBox("Show Numbers");
        this.showNumbers.setSelected(this.doShowNumbers);
        this.showNumbers.addItemListener(this);
        this.showNumbers.setMaximumSize(this.showNumbers.getPreferredSize());
        this.showGraph = new JCheckBox("Show Graphs");
        this.showGraph.setSelected(this.doShowGraph);
        this.showGraph.addItemListener(this);
        this.showGraph.setMaximumSize(this.showGraph.getPreferredSize());
        this.showGrids = new JCheckBox("Show Grids");
        this.showGrids.setSelected(this.doShowGrids);
        this.showGrids.addItemListener(this);
        this.showGrids.setMaximumSize(this.showGrids.getPreferredSize());
        this.showOrder = new JCheckBox("Show Order");
        this.showOrder.setSelected(this.doShowOrder);
        this.showOrder.addItemListener(this);
        this.showOrder.setMaximumSize(this.showOrder.getPreferredSize());
        this.showSquares = new JCheckBox("Show Squares");
        this.showSquares.setSelected(this.doShowSquares);
        this.showSquares.addItemListener(this);
        this.showSquares.setMaximumSize(this.showSquares.getPreferredSize());
        this.showContour = new JCheckBox("Show Contour");
        this.showContour.setSelected(this.doShowContour);
        this.showContour.addItemListener(this);
        this.showContour.setMaximumSize(this.showContour.getPreferredSize());
        this.selectRows = new JSpinner(new SpinnerNumberModel(gridRows, 2, 100, 1));
        this.selectRows.addChangeListener(this);
        this.selectRows.setMaximumSize(this.selectRows.getPreferredSize());
        this.selectColumns = new JSpinner(new SpinnerNumberModel(gridColumns, 2, 100, 1));
        this.selectColumns.addChangeListener(this);
        this.selectColumns.setMaximumSize(this.selectColumns.getPreferredSize());
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(this.thresholdLevel, 0, 255, 20));
        this.thresholdSpinner.addChangeListener(this);
        this.thresholdSpinner.setMaximumSize(this.thresholdSpinner.getPreferredSize());
        this.manualThreshold = new JCheckBox("Manual");
        this.manualThreshold.setSelected(this.isManual);
        this.manualThreshold.addItemListener(this);
        this.manualThreshold.setMaximumSize(this.manualThreshold.getPreferredSize());
        if (!this.isManual) {
            this.thresholdSpinner.setEnabled(false);
        }
        this.addLabeled(this.successIndicator, "Found:", this);
        this.addSeparator(100);
        this.addLabeled(this.viewSelector, "View ", this);
        this.addSeparator(100);
        this.addLabeled(this.selectRows, "Rows", this);
        this.addLabeled(this.selectColumns, "Cols", this);
        if (hasManualMode) {
            this.addAlignLeft(this.manualThreshold, this);
        }
        this.addLabeled(this.thresholdSpinner, "Threshold", this);
        this.addSeparator(100);
        this.addLabeled(this.selectZoom, "Zoom ", this);
        this.addAlignLeft(this.showPoints, this);
        this.addAlignLeft(this.showNumbers, this);
        this.addAlignLeft(this.showGraph, this);
        this.addAlignLeft(this.showGrids, this);
        this.addAlignLeft(this.showOrder, this);
        this.addAlignLeft(this.showSquares, this);
        this.addAlignLeft(this.showContour, this);
    }

    public void addView(String name) {
        this.viewSelector.addItem(name);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.thresholdSpinner) {
            this.thresholdLevel = ((Number)this.thresholdSpinner.getValue()).intValue();
            if (this.isManual) {
                this.listener.calibEventDetectorModified();
            }
        } else if (e.getSource() == this.selectRows) {
            this.gridRows = ((Number)this.selectRows.getValue()).intValue();
            this.listener.calibEventDetectorModified();
        } else if (e.getSource() == this.selectColumns) {
            this.gridColumns = ((Number)this.selectColumns.getValue()).intValue();
            this.listener.calibEventDetectorModified();
        } else if (e.getSource() == this.selectZoom) {
            this.scale = ((Number)this.selectZoom.getValue()).doubleValue();
            this.listener.calibEventGUI();
        }
    }

    public void setSuccessMessage(String message, boolean worked) {
        this.successIndicator.setText(message);
        if (worked) {
            this.successIndicator.setForeground(Color.BLACK);
        } else {
            this.successIndicator.setForeground(Color.RED);
        }
    }

    public int getSelectedView() {
        return this.selectedView;
    }

    public boolean isShowSquares() {
        return this.doShowSquares;
    }

    public boolean isShowPoints() {
        return this.doShowPoints;
    }

    public boolean isShowNumbers() {
        return this.doShowNumbers;
    }

    public boolean isShowGraph() {
        return this.doShowGraph;
    }

    public boolean isShowGrids() {
        return this.doShowGrids;
    }

    public boolean isShowOrder() {
        return this.doShowOrder;
    }

    public int getThresholdLevel() {
        return this.thresholdLevel;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public double getScale() {
        return this.scale;
    }

    public void setThreshold(int threshold) {
        this.thresholdSpinner.setValue(threshold);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.viewSelector) {
            this.selectedView = this.viewSelector.getSelectedIndex();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showSquares) {
            this.doShowSquares = this.showSquares.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showNumbers) {
            this.doShowNumbers = this.showNumbers.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showPoints) {
            this.doShowPoints = this.showPoints.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showGraph) {
            this.doShowGraph = this.showGraph.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showGrids) {
            this.doShowGrids = this.showGrids.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showOrder) {
            this.doShowOrder = this.showOrder.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.showContour) {
            this.doShowContour = this.showContour.isSelected();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.thresholdSpinner) {
            this.thresholdLevel = ((Number)this.thresholdSpinner.getValue()).intValue();
            if (this.isManual) {
                this.listener.calibEventDetectorModified();
            }
        } else if (e.getSource() == this.selectZoom) {
            this.scale = ((Number)this.selectZoom.getValue()).doubleValue();
            this.listener.calibEventGUI();
        } else if (e.getSource() == this.manualThreshold && this.isManual != this.manualThreshold.isSelected()) {
            this.isManual = this.manualThreshold.isSelected();
            this.thresholdSpinner.setEnabled(this.isManual);
            this.listener.calibEventDetectorModified();
        }
    }

    public int getGridRows() {
        return this.gridRows;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double curr = ((Number)this.selectZoom.getValue()).doubleValue();
        curr = e.getWheelRotation() > 0 ? (curr *= 1.1) : (curr /= 1.1);
        this.setScale(curr);
    }

    public void setScale(double scale) {
        double curr = scale >= 1.0 ? ZOOM_INC * (double)((int)(scale / ZOOM_INC + 0.5)) : scale;
        if (curr < ZOOM_MIN) {
            curr = ZOOM_MIN;
        }
        if (curr > ZOOM_MAX) {
            curr = ZOOM_MAX;
        }
        this.selectZoom.setValue(curr);
    }

    public static interface Listener {
        public void calibEventGUI();

        public void calibEventDetectorModified();
    }
}

