/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.gui.binary.HistogramThresholdPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectHistogramThresholdPanel
extends JPanel
implements ChangeListener,
ActionListener {
    JSlider thresholdLevel;
    HistogramThresholdPanel histogramPanel;
    JButton toggleButton;
    Listener listener;
    int valueThreshold;
    boolean valueDown;

    public SelectHistogramThresholdPanel(int threshold, boolean directionDown) {
        this.valueThreshold = threshold;
        this.valueDown = directionDown;
        this.histogramPanel = new HistogramThresholdPanel(256, 256.0);
        this.histogramPanel.setPreferredSize(new Dimension(120, 60));
        this.histogramPanel.setMaximumSize(this.histogramPanel.getPreferredSize());
        this.thresholdLevel = new JSlider(0, 0, 255, 20);
        this.thresholdLevel.setMajorTickSpacing(20);
        this.thresholdLevel.setPaintTicks(true);
        this.thresholdLevel.addChangeListener(this);
        this.thresholdLevel.setValue(threshold);
        this.toggleButton = new JButton();
        this.toggleButton.setPreferredSize(new Dimension(100, 30));
        this.toggleButton.setMaximumSize(this.toggleButton.getPreferredSize());
        this.toggleButton.setMinimumSize(this.toggleButton.getPreferredSize());
        this.setToggleText();
        this.toggleButton.addActionListener(this);
        this.add(this.histogramPanel);
        this.add(Box.createRigidArea(new Dimension(8, 8)));
        this.add(this.thresholdLevel);
        this.add(this.toggleButton);
    }

    public HistogramThresholdPanel getHistogramPanel() {
        return this.histogramPanel;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public int getThreshold() {
        return this.valueThreshold;
    }

    public boolean isDown() {
        return this.valueDown;
    }

    private void setToggleText() {
        if (this.valueDown) {
            this.toggleButton.setText("down");
        } else {
            this.toggleButton.setText("Up");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.thresholdLevel) {
            int oldValue = this.valueThreshold;
            this.valueThreshold = this.thresholdLevel.getValue();
            if (oldValue == this.valueThreshold) {
                return;
            }
        }
        this.histogramPanel.setThreshold(this.valueThreshold, this.valueDown);
        this.histogramPanel.repaint();
        if (this.listener != null) {
            this.listener.histogramThresholdChange();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.toggleButton) {
            this.valueDown = !this.valueDown;
            this.setToggleText();
        }
        this.histogramPanel.setThreshold(this.valueThreshold, this.valueDown);
        this.histogramPanel.repaint();
        if (this.listener != null) {
            this.listener.histogramThresholdChange();
        }
    }

    public void setThreshold(int threshold) {
        this.valueThreshold = threshold;
        this.thresholdLevel.setValue(threshold);
        this.histogramPanel.setThreshold(this.valueThreshold, this.valueDown);
    }

    public static interface Listener {
        public void histogramThresholdChange();
    }
}

