/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageGrayDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageGray;

public class BaseIntegralEdge<T extends ImageGray> {
    Class<T> imageType;
    protected ImageLineIntegral integral;
    protected GImageGray integralImage;

    public BaseIntegralEdge(Class<T> imageType) {
        this.imageType = imageType;
        this.integral = new ImageLineIntegral();
        this.integralImage = FactoryGImageGray.create(imageType);
    }

    public void setTransform(PixelTransform_F32 undistToDist) {
        InterpolatePixelS<T> interpolate = FactoryInterpolation.bilinearPixelS(this.imageType, BorderType.EXTENDED);
        this.integralImage = new GImageGrayDistorted<T>(undistToDist, interpolate);
    }

    public void setImage(T image) {
        this.integralImage.wrap((ImageGray)image);
        this.integral.setImage(this.integralImage);
    }
}

