/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.slic;

import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class SegmentSlic_PlU8
extends SegmentSlic<Planar<GrayU8>> {
    public SegmentSlic_PlU8(int numberOfRegions, float m, int totalIterations, ConnectRule connectRule, int numBands) {
        super(numberOfRegions, m, totalIterations, connectRule, ImageType.pl(numBands, GrayU8.class));
    }

    @Override
    public void setColor(float[] color, int x, int y) {
        int numBands = ((Planar)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            color[i] = ((GrayU8)((Planar)this.input).getBand(i)).unsafe_get(x, y);
        }
    }

    @Override
    public void addColor(float[] color, int index, float weight) {
        int numBands = ((Planar)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            int n = i;
            color[n] = color[n] + (float)(((GrayU8)((Planar)this.input).getBand((int)i)).data[index] & 0xFF) * weight;
        }
    }

    @Override
    public float colorDistance(float[] color, int index) {
        int numBands = ((Planar)this.input).getNumBands();
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            float diff = (float)(((GrayU8)((Planar)this.input).getBand((int)i)).data[index] & 0xFF) - color[i];
            total += diff * diff;
        }
        return total;
    }

    @Override
    public float getIntensity(int x, int y) {
        int numBands = ((Planar)this.input).getNumBands();
        int index = ((Planar)this.input).getIndex(x, y);
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            total += (float)(((GrayU8)((Planar)this.input).getBand((int)i)).data[index] & 0xFF);
        }
        return total / (float)numBands;
    }
}

