/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.sfm.Stereo2D3D;
import boofcv.struct.sfm.StereoPose;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class PnPStereoResidualReprojection
implements ModelObservationResidualN<StereoPose, Stereo2D3D> {
    StereoPose motion;
    Point3D_F64 temp = new Point3D_F64();

    @Override
    public void setModel(StereoPose model) {
        this.motion = model;
    }

    @Override
    public int computeResiduals(Stereo2D3D data, double[] residuals, int index) {
        SePointOps_F64.transform((Se3_F64)this.motion.worldToCam0, (Point3D_F64)data.location, (Point3D_F64)this.temp);
        double expectedX = this.temp.x / this.temp.z;
        double expectedY = this.temp.y / this.temp.z;
        residuals[index++] = expectedX - data.leftObs.x;
        residuals[index++] = expectedY - data.leftObs.y;
        SePointOps_F64.transform((Se3_F64)this.motion.cam0ToCam1, (Point3D_F64)this.temp, (Point3D_F64)this.temp);
        expectedX = this.temp.x / this.temp.z;
        expectedY = this.temp.y / this.temp.z;
        residuals[index++] = expectedX - data.rightObs.x;
        residuals[index++] = expectedY - data.rightObs.y;
        return index;
    }

    @Override
    public int getN() {
        return 4;
    }
}

