/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public abstract class FundamentalLinear {
    protected DenseMatrix64F A = new DenseMatrix64F(1, 9);
    protected SingularValueDecomposition<DenseMatrix64F> svdNull = DecompositionFactory.svd((int)9, (int)9, (boolean)false, (boolean)true, (boolean)false);
    protected SingularValueDecomposition<DenseMatrix64F> svdConstraints = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);
    protected DenseMatrix64F svdU;
    protected DenseMatrix64F svdS;
    protected DenseMatrix64F svdV;
    protected DenseMatrix64F temp0 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F N1 = new DenseMatrix64F(3, 3);
    protected DenseMatrix64F N2 = new DenseMatrix64F(3, 3);
    boolean computeFundamental;

    public FundamentalLinear(boolean computeFundamental) {
        this.computeFundamental = computeFundamental;
    }

    protected boolean projectOntoEssential(DenseMatrix64F E) {
        if (!this.svdConstraints.decompose((Matrix)E)) {
            return false;
        }
        this.svdV = (DenseMatrix64F)this.svdConstraints.getV((Matrix)this.svdV, false);
        this.svdU = (DenseMatrix64F)this.svdConstraints.getU((Matrix)this.svdU, false);
        this.svdS = (DenseMatrix64F)this.svdConstraints.getW((Matrix)this.svdS);
        SingularOps.descendingOrder((DenseMatrix64F)this.svdU, (boolean)false, (DenseMatrix64F)this.svdS, (DenseMatrix64F)this.svdV, (boolean)false);
        this.svdS.unsafe_set(0, 0, 1.0);
        this.svdS.unsafe_set(1, 1, 1.0);
        this.svdS.unsafe_set(2, 2, 0.0);
        CommonOps.mult((RowD1Matrix64F)this.svdU, (RowD1Matrix64F)this.svdS, (RowD1Matrix64F)this.temp0);
        CommonOps.multTransB((RowD1Matrix64F)this.temp0, (RowD1Matrix64F)this.svdV, (RowD1Matrix64F)E);
        return true;
    }

    protected boolean projectOntoFundamentalSpace(DenseMatrix64F F) {
        if (!this.svdConstraints.decompose((Matrix)F)) {
            return false;
        }
        this.svdV = (DenseMatrix64F)this.svdConstraints.getV((Matrix)this.svdV, false);
        this.svdU = (DenseMatrix64F)this.svdConstraints.getU((Matrix)this.svdU, false);
        this.svdS = (DenseMatrix64F)this.svdConstraints.getW((Matrix)this.svdS);
        SingularOps.descendingOrder((DenseMatrix64F)this.svdU, (boolean)false, (DenseMatrix64F)this.svdS, (DenseMatrix64F)this.svdV, (boolean)false);
        this.svdS.set(2, 2, 0.0);
        CommonOps.mult((RowD1Matrix64F)this.svdU, (RowD1Matrix64F)this.svdS, (RowD1Matrix64F)this.temp0);
        CommonOps.multTransB((RowD1Matrix64F)this.temp0, (RowD1Matrix64F)this.svdV, (RowD1Matrix64F)F);
        return true;
    }

    protected void undoNormalizationF(DenseMatrix64F M, DenseMatrix64F N1, DenseMatrix64F N2) {
        CommonOps.multTransA((RowD1Matrix64F)N2, (RowD1Matrix64F)M, (RowD1Matrix64F)this.temp0);
        CommonOps.mult((RowD1Matrix64F)this.temp0, (RowD1Matrix64F)N1, (RowD1Matrix64F)M);
    }

    protected void createA(List<AssociatedPair> points, DenseMatrix64F A) {
        A.reshape(points.size(), 9, false);
        A.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            LowLevelMultiViewOps.applyPixelNormalization(this.N1, f, f_norm);
            LowLevelMultiViewOps.applyPixelNormalization(this.N2, s, s_norm);
            A.unsafe_set(i, 0, s_norm.x * f_norm.x);
            A.unsafe_set(i, 1, s_norm.x * f_norm.y);
            A.unsafe_set(i, 2, s_norm.x);
            A.unsafe_set(i, 3, s_norm.y * f_norm.x);
            A.unsafe_set(i, 4, s_norm.y * f_norm.y);
            A.unsafe_set(i, 5, s_norm.y);
            A.unsafe_set(i, 6, f_norm.x);
            A.unsafe_set(i, 7, f_norm.y);
            A.unsafe_set(i, 8, 1.0);
        }
    }

    public DenseMatrix64F getSvdU() {
        return this.svdU;
    }

    public DenseMatrix64F getSvdS() {
        return this.svdS;
    }

    public DenseMatrix64F getSvdV() {
        return this.svdV;
    }

    public boolean isComputeFundamental() {
        return this.computeFundamental;
    }
}

