/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.Zhang99ParamCamera;
import boofcv.struct.calib.IntrinsicParameters;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.so.Rodrigues_F64;

public class Zhang99ParamAll
extends Zhang99ParamCamera {
    public View[] views;

    public Zhang99ParamAll(boolean assumeZeroSkew, int numRadial, boolean includeTangential, int numViews) {
        super(assumeZeroSkew, numRadial, includeTangential);
        this.setNumberOfViews(numViews);
    }

    public Zhang99ParamAll(boolean assumeZeroSkew, int numRadial, boolean includeTangential) {
        super(assumeZeroSkew, numRadial, includeTangential);
    }

    public Zhang99ParamAll() {
    }

    public void setNumberOfViews(int numViews) {
        this.views = new View[numViews];
        for (int i = 0; i < numViews; ++i) {
            this.views[i] = new View();
        }
    }

    public Zhang99ParamAll createNew() {
        return new Zhang99ParamAll(this.assumeZeroSkew, this.radial.length, this.includeTangential, this.views.length);
    }

    public Zhang99ParamAll copy() {
        int i;
        Zhang99ParamAll ret = this.createNew();
        ret.a = this.a;
        ret.b = this.b;
        ret.c = this.c;
        ret.x0 = this.x0;
        ret.y0 = this.y0;
        for (i = 0; i < this.radial.length; ++i) {
            ret.radial[i] = this.radial[i];
        }
        ret.t1 = this.t1;
        ret.t2 = this.t2;
        ret.includeTangential = this.includeTangential;
        for (i = 0; i < this.views.length; ++i) {
            View a = this.views[i];
            View b = ret.views[i];
            b.rotation.unitAxisRotation.set(a.rotation.unitAxisRotation);
            b.rotation.theta = a.rotation.theta;
            b.T.set(a.T);
        }
        return ret;
    }

    @Override
    public int numParameters() {
        return super.numParameters() + 6 * this.views.length;
    }

    @Override
    public int setFromParam(double[] param) {
        int index = super.setFromParam(param);
        for (View v : this.views) {
            v.rotation.setParamVector(param[index++], param[index++], param[index++]);
            v.T.x = param[index++];
            v.T.y = param[index++];
            v.T.z = param[index++];
        }
        return index;
    }

    @Override
    public int convertToParam(double[] param) {
        int index = super.convertToParam(param);
        for (View v : this.views) {
            param[index++] = v.rotation.unitAxisRotation.x * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.y * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.z * v.rotation.theta;
            param[index++] = v.T.x;
            param[index++] = v.T.y;
            param[index++] = v.T.z;
        }
        return index;
    }

    public IntrinsicParameters convertToIntrinsic() {
        IntrinsicParameters ret = new IntrinsicParameters();
        ret.fx = this.a;
        ret.fy = this.b;
        ret.skew = this.assumeZeroSkew ? 0.0 : this.c;
        ret.cx = this.x0;
        ret.cy = this.y0;
        ret.radial = new double[this.radial.length];
        System.arraycopy(this.radial, 0, ret.radial, 0, this.radial.length);
        if (this.includeTangential) {
            ret.t1 = this.t1;
            ret.t2 = this.t2;
        } else {
            ret.t2 = 0.0;
            ret.t1 = 0.0;
        }
        return ret;
    }

    public static class View {
        public Rodrigues_F64 rotation = new Rodrigues_F64();
        public Vector3D_F64 T = new Vector3D_F64();
    }
}

