/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.distort.FDistort;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.core.image.ConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.util.ArrayList;
import java.util.List;

public class DetectFiducialSquareImage<T extends ImageGray>
extends BaseDetectFiducialSquare<T> {
    private static final int w = 16;
    private static final int squareLength = 64;
    private static final int DESC_LENGTH = 256;
    private GrayU8 binary = new GrayU8(64, 64);
    private List<FiducialDef> targets = new ArrayList<FiducialDef>();
    private short[] squareDef = new short[256];
    private GrayF32 grayNoBorder = new GrayF32();
    private int hammingThreshold;

    public DetectFiducialSquareImage(InputToBinary<T> inputToBinary, BinaryPolygonDetector<T> quadDetector, double borderWidthFraction, double minimumBlackBorderFraction, double matchThreshold, Class<T> inputType) {
        super(inputToBinary, quadDetector, borderWidthFraction, minimumBlackBorderFraction, (int)Math.round(64.0 / (1.0 - 2.0 * borderWidthFraction)), inputType);
        this.hammingThreshold = (int)(4096.0 * matchThreshold);
    }

    public int addPattern(GrayU8 inputBinary, double lengthSide) {
        if (inputBinary == null) {
            throw new IllegalArgumentException("Input image is null.");
        }
        if (lengthSide <= 0.0) {
            throw new IllegalArgumentException("Parameter lengthSide must be more than zero");
        }
        if (ImageStatistics.max(inputBinary) > 1) {
            throw new IllegalArgumentException("A binary image is composed on 0 and 1 pixels.  This isn't binary!");
        }
        if (inputBinary.width != 64 || inputBinary.height != 64) {
            GrayF32 inputGray = new GrayF32(inputBinary.width, inputBinary.height);
            ConvertImage.convert(inputBinary, inputGray);
            PixelMath.multiply(inputGray, 255.0f, inputGray);
            GrayF32 scaled = new GrayF32(64, 64);
            if (inputBinary.width > 64 && inputBinary.height > 64) {
                AverageDownSampleOps.down(inputGray, scaled);
            } else {
                new FDistort(inputGray, scaled).scaleExt().apply();
            }
            GThresholdImageOps.threshold(scaled, this.binary, 127.5, false);
        } else {
            this.binary.setTo(inputBinary);
        }
        FiducialDef def = new FiducialDef();
        def.lengthSide = lengthSide;
        DetectFiducialSquareImage.binaryToDef(this.binary, def.desc[0]);
        ImageMiscOps.rotateCCW(this.binary);
        DetectFiducialSquareImage.binaryToDef(this.binary, def.desc[1]);
        ImageMiscOps.rotateCCW(this.binary);
        DetectFiducialSquareImage.binaryToDef(this.binary, def.desc[2]);
        ImageMiscOps.rotateCCW(this.binary);
        DetectFiducialSquareImage.binaryToDef(this.binary, def.desc[3]);
        int index = this.targets.size();
        this.targets.add(def);
        return index;
    }

    protected static void binaryToDef(GrayU8 binary, short[] desc) {
        for (int i = 0; i < binary.data.length; i += 16) {
            int value = 0;
            for (int j = 0; j < 16; ++j) {
                value |= binary.data[i + j] << j;
            }
            desc[i / 16] = (short)value;
        }
    }

    @Override
    protected boolean processSquare(GrayF32 gray, BaseDetectFiducialSquare.Result result, double edgeInside, double edgeOutside) {
        int off = (gray.width - this.binary.width) / 2;
        gray.subimage(off, off, off + this.binary.width, off + this.binary.width, this.grayNoBorder);
        float threshold = (float)((edgeInside + edgeOutside) / 2.0);
        GThresholdImageOps.threshold(this.grayNoBorder, this.binary, threshold, false);
        DetectFiducialSquareImage.binaryToDef(this.binary, this.squareDef);
        boolean matched = false;
        int bestScore = this.hammingThreshold + 1;
        for (int i = 0; i < this.targets.size(); ++i) {
            FiducialDef def = this.targets.get(i);
            for (int j = 0; j < 4; ++j) {
                int score = this.hamming(def.desc[j], this.squareDef);
                if (score >= bestScore) continue;
                bestScore = score;
                result.rotation = j;
                result.which = i;
                result.lengthSide = def.lengthSide;
                matched = true;
            }
        }
        return matched;
    }

    protected int hamming(short[] a, short[] b) {
        int distance = 0;
        for (int i = 0; i < a.length; ++i) {
            distance += DescriptorDistance.hamming(a[i] & 0xFFFF ^ b[i] & 0xFFFF);
        }
        return distance;
    }

    public List<FiducialDef> getTargets() {
        return this.targets;
    }

    public static class FiducialDef {
        public short[][] desc = new short[4][256];
        public double lengthSide;
    }
}

