/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public abstract class ImplSsdCornerBase<D extends ImageGray, D2 extends ImageGray>
implements GradientCornerIntensity<D> {
    protected D derivX;
    protected D derivY;
    protected int radius;
    protected D2 horizXX;
    protected D2 horizXY;
    protected D2 horizYY;
    protected int x;
    protected int y;

    public ImplSsdCornerBase(int windowRadius, Class<D2> secondDerivType) {
        this.radius = windowRadius;
        this.horizXX = GeneralizedImageOps.createSingleBand(secondDerivType, 1, 1);
        this.horizXY = GeneralizedImageOps.createSingleBand(secondDerivType, 1, 1);
        this.horizYY = GeneralizedImageOps.createSingleBand(secondDerivType, 1, 1);
    }

    public void setImageShape(int imageWidth, int imageHeight) {
        ((ImageGray)this.horizXX).reshape(imageWidth, imageHeight);
        ((ImageGray)this.horizYY).reshape(imageWidth, imageHeight);
        ((ImageGray)this.horizXY).reshape(imageWidth, imageHeight);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    protected abstract float computeIntensity();

    @Override
    public int getIgnoreBorder() {
        return this.radius;
    }

    @Override
    public void process(D derivX, D derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape(derivX, derivY, intensity);
        this.setImageShape(((ImageBase)derivX).getWidth(), ((ImageBase)derivX).getHeight());
        this.derivX = derivX;
        this.derivY = derivY;
        ImageMiscOps.fillBorder(intensity, 0.0f, this.radius);
        this.horizontal();
        this.vertical(intensity);
    }

    protected abstract void horizontal();

    protected abstract void vertical(GrayF32 var1);
}

