/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformLineFootOfNorm;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectLineHoughFootSubimage<I extends ImageGray, D extends ImageGray>
implements DetectLine<I> {
    int totalHorizontalDivisions;
    int totalVerticalDivisions;
    HoughTransformLineFootOfNorm alg;
    ImageGradient<I, D> gradient;
    float thresholdEdge;
    D derivX;
    D derivY;
    GrayF32 intensity = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    ImageLinePruneMerge post = new ImageLinePruneMerge();
    int maxLines;

    public DetectLineHoughFootSubimage(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int totalHorizontalDivisions, int totalVerticalDivisions, int maxLines, ImageGradient<I, D> gradient) {
        this.gradient = gradient;
        this.thresholdEdge = thresholdEdge;
        this.totalHorizontalDivisions = totalHorizontalDivisions;
        this.totalVerticalDivisions = totalVerticalDivisions;
        this.maxLines = maxLines;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmaxCandidate(new ConfigExtract(localMaxRadius, minCounts, 0, false));
        this.alg = new HoughTransformLineFootOfNorm(extractor, minDistanceFromOrigin);
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.intensity.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.binary.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        ThresholdImageOps.threshold(this.intensity, this.binary, this.thresholdEdge, false);
        ArrayList<LineParametric2D_F32> ret = new ArrayList();
        this.post.reset();
        for (int i = 0; i < this.totalVerticalDivisions; ++i) {
            int y0 = ((ImageGray)input).height * i / this.totalVerticalDivisions;
            int y1 = ((ImageGray)input).height * (i + 1) / this.totalVerticalDivisions;
            for (int j = 0; j < this.totalHorizontalDivisions; ++j) {
                int x0 = ((ImageGray)input).width * j / this.totalVerticalDivisions;
                int x1 = ((ImageGray)input).width * (j + 1) / this.totalVerticalDivisions;
                this.processSubimage(x0, y0, x1, y1, ret);
            }
        }
        ret = this.pruneLines(input);
        return ret;
    }

    private List<LineParametric2D_F32> pruneLines(I input) {
        this.post.pruneSimilar(0.12566371f, 10.0f, ((ImageGray)input).width, ((ImageGray)input).height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList();
    }

    private void processSubimage(int x0, int y0, int x1, int y1, List<LineParametric2D_F32> found) {
        ImageGray derivX = (ImageGray)((ImageBase)this.derivX).subimage(x0, y0, x1, y1);
        ImageGray derivY = (ImageGray)((ImageBase)this.derivY).subimage(x0, y0, x1, y1);
        GrayU8 binary = (GrayU8)this.binary.subimage(x0, y0, x1, y1);
        this.alg.transform(derivX, derivY, binary);
        FastQueue<LineParametric2D_F32> lines = this.alg.extractLines();
        float[] intensity = this.alg.getFoundIntensity();
        for (int i = 0; i < lines.size; ++i) {
            LineParametric2D_F32 l = ((LineParametric2D_F32)lines.get(i)).copy();
            l.p.x += (float)x0;
            l.p.y += (float)y0;
            found.add(l);
            this.post.add(l, intensity[i]);
        }
    }

    public HoughTransformLineFootOfNorm getTransform() {
        return this.alg;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public GrayF32 getEdgeIntensity() {
        return this.intensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

