/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformLineFootOfNorm;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectLineHoughFoot<I extends ImageGray, D extends ImageGray>
implements DetectLine<I> {
    HoughTransformLineFootOfNorm alg;
    ImageGradient<I, D> gradient;
    float thresholdEdge;
    D derivX;
    D derivY;
    GrayF32 intensity = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    int maxLines;
    ImageLinePruneMerge post = new ImageLinePruneMerge();

    public DetectLineHoughFoot(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int maxLines, ImageGradient<I, D> gradient) {
        this.gradient = gradient;
        this.thresholdEdge = thresholdEdge;
        this.maxLines = maxLines;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmaxCandidate(new ConfigExtract(localMaxRadius, minCounts, 0, false));
        this.alg = new HoughTransformLineFootOfNorm(extractor, minDistanceFromOrigin);
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.intensity.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.binary.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        ThresholdImageOps.threshold(this.intensity, this.binary, this.thresholdEdge, false);
        this.alg.transform(this.derivX, this.derivY, this.binary);
        FastQueue<LineParametric2D_F32> lines = this.alg.extractLines();
        List<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        for (int i = 0; i < lines.size; ++i) {
            ret.add((LineParametric2D_F32)lines.get(i));
        }
        ret = this.pruneLines(input, ret);
        return ret;
    }

    private List<LineParametric2D_F32> pruneLines(I input, List<LineParametric2D_F32> ret) {
        float[] intensity = this.alg.getFoundIntensity();
        this.post.reset();
        for (int i = 0; i < ret.size(); ++i) {
            this.post.add(ret.get(i), intensity[i]);
        }
        this.post.pruneSimilar(0.12566371f, 10.0f, ((ImageGray)input).width, ((ImageGray)input).height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList();
    }

    public HoughTransformLineFootOfNorm getTransform() {
        return this.alg;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public GrayF32 getEdgeIntensity() {
        return this.intensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

