/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.TxBlock;
import org.mapdb.TxRollbackException;

public class TxMaker
implements Closeable {
    private final boolean strictDBGet;
    protected ScheduledExecutorService executor;
    protected Engine engine;
    protected final Fun.Function1<Class, String> serializerClassLoader;

    public TxMaker(Engine engine) {
        this(engine, false, null, null);
    }

    public TxMaker(Engine engine, boolean strictDBGet, ScheduledExecutorService executor, Fun.Function1<Class, String> serializerClassLoader) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        if (!engine.canSnapshot()) {
            throw new IllegalArgumentException("Snapshot must be enabled for TxMaker");
        }
        if (engine.isReadOnly()) {
            throw new IllegalArgumentException("TxMaker can not be used with read-only Engine");
        }
        this.engine = engine;
        this.strictDBGet = strictDBGet;
        this.executor = executor;
        this.serializerClassLoader = serializerClassLoader;
    }

    public DB makeTx() {
        Engine snapshot = this.engine.snapshot();
        if (snapshot.isReadOnly()) {
            throw new AssertionError();
        }
        return new DB(snapshot, this.strictDBGet, false, this.executor, true, null, 0L, null, null, this.serializerClassLoader);
    }

    @Override
    public void close() {
        this.engine.close();
        this.engine = null;
    }

    public void execute(TxBlock txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                txBlock.tx(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return;
            }
            catch (TxRollbackException e) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }

    public <A> A execute(Fun.Function1<A, DB> txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                A a = txBlock.run(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return a;
            }
            catch (TxRollbackException e) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }
}

