/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Storage;
import org.mapdb.Volume;

public class StorageDirect
extends Storage
implements Engine {
    public StorageDirect(Volume.Factory volFac) {
        this(volFac, false, false, false, false);
    }

    public StorageDirect(Volume.Factory volFac, boolean appendOnly, boolean deleteFilesOnExit, boolean failOnWrongHeader, boolean readOnly) {
        super(volFac, appendOnly, deleteFilesOnExit, failOnWrongHeader, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, value);
        try {
            this.lock.writeLock().lock();
            long recid = this.longStackTake(3L);
            if (recid == 0L) {
                long indexSize = this.index.getLong(16L);
                if (indexSize % 8L != 0L) {
                    throw new InternalError();
                }
                recid = indexSize / 8L;
                this.index.ensureAvailable(indexSize + 8L);
                this.index.putLong(16L, indexSize + 8L);
            }
            if (out.pos < 65535) {
                long indexValue = out.pos != 0 ? this.freePhysRecTake(out.pos) : 0L;
                this.phys.putData(indexValue & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                this.index.putLong(recid * 8L, indexValue);
            } else {
                this.putLargeLinkedRecord(out, recid);
            }
            long l = recid;
            this.lock.writeLock().unlock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private void putLargeLinkedRecord(DataOutput2 out, long recid) throws IOException {
        int chunkSize = 65527;
        int lastArrayPos = out.pos;
        long lastChunkPhysId = 0L;
        for (int arrayPos = out.pos - out.pos % 65527; arrayPos >= 0; arrayPos -= 65527) {
            int currentChunkSize = lastArrayPos - arrayPos;
            byte[] b = new byte[currentChunkSize + 8];
            ByteBuffer.wrap(b).putLong(0, lastChunkPhysId);
            System.arraycopy(out.buf, arrayPos, b, 8, currentChunkSize);
            lastChunkPhysId = this.freePhysRecTake(currentChunkSize + 8);
            this.phys.putData(lastChunkPhysId & 0xFFFFFFFFFFFFL, b, b.length);
            lastArrayPos = arrayPos;
        }
        this.index.putLong(recid * 8L, lastChunkPhysId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        try {
            try {
                this.lock.readLock().lock();
                long indexValue = this.index.getLong(recid * 8L);
                A a = this.recordGet2(indexValue, this.phys, serializer);
                return a;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, value);
            try {
                this.lock.writeLock().lock();
                long oldIndexVal = this.index.getLong(recid * 8L);
                long oldSize = oldIndexVal >>> 48;
                if (out.pos < 65535) {
                    if (oldSize == 0L && out.pos == 0) {
                    } else if (oldSize == (long)out.pos && oldSize != 65535L) {
                        this.phys.putData(oldIndexVal & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                    } else if (oldSize != 0L && out.pos == 0) {
                        this.freePhysRecPut(oldIndexVal);
                        this.index.putLong(recid * 8L, 0L);
                    } else {
                        long newIndexValue = this.freePhysRecTake(out.pos);
                        this.phys.putData(newIndexValue & 0xFFFFFFFFFFFFL, out.buf, out.pos);
                        this.index.putLong(recid * 8L, newIndexValue);
                        this.unlinkPhysRecord(oldIndexVal);
                    }
                } else {
                    this.putLargeLinkedRecord(out, recid);
                    this.unlinkPhysRecord(oldIndexVal);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void delete(long recid) {
        try {
            this.lock.writeLock().lock();
            long oldIndexVal = this.index.getLong(recid * 8L);
            this.index.putLong(recid * 8L, 0L);
            this.longStackPut(3L, recid);
            this.unlinkPhysRecord(oldIndexVal);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Can not rollback, transactions disabled.");
    }

    @Override
    protected long longStackTake(long listRecid) throws IOException {
        long dataOffset = this.index.getLong(listRecid * 8L) & 0xFFFFFFFFFFFFL;
        if (dataOffset == 0L) {
            return 0L;
        }
        this.writeLock_checkLocked();
        int numberOfRecordsInPage = this.phys.getUnsignedByte(dataOffset);
        if (numberOfRecordsInPage <= 0) {
            throw new InternalError();
        }
        if (numberOfRecordsInPage > 100) {
            throw new InternalError();
        }
        long ret = this.phys.getLong(dataOffset + (long)(numberOfRecordsInPage * 8));
        if (numberOfRecordsInPage == 1) {
            long previousListPhysid = this.phys.getLong(dataOffset) & 0xFFFFFFFFFFFFL;
            if (previousListPhysid != 0L) {
                this.index.putLong(listRecid * 8L, previousListPhysid | 0x328000000000000L);
            } else {
                this.index.putLong(listRecid * 8L, 0L);
            }
            this.freePhysRecPut(dataOffset | 0x328000000000000L);
        } else {
            this.phys.putUnsignedByte(dataOffset, (byte)(numberOfRecordsInPage - 1));
        }
        return ret;
    }

    @Override
    protected void longStackPut(long listRecid, long offset) throws IOException {
        this.writeLock_checkLocked();
        long listPhysid2 = this.index.getLong(listRecid * 8L) & 0xFFFFFFFFFFFFL;
        if (listPhysid2 == 0L) {
            long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
            if (listPhysid == 0L) {
                throw new InternalError();
            }
            this.phys.putLong(listPhysid, 0L);
            this.phys.putUnsignedByte(listPhysid, 1);
            this.phys.putLong(listPhysid + 8L, offset);
            this.index.putLong(listRecid * 8L, 0x328000000000000L | listPhysid);
        } else {
            int numberOfRecordsInPage = this.phys.getUnsignedByte(listPhysid2);
            if (numberOfRecordsInPage == 100) {
                long listPhysid = this.freePhysRecTake(808) & 0xFFFFFFFFFFFFL;
                if (listPhysid == 0L) {
                    throw new InternalError();
                }
                this.phys.putLong(listPhysid, listPhysid2);
                this.phys.putUnsignedByte(listPhysid, 1);
                this.phys.putLong(listPhysid + 8L, offset);
                this.index.putLong(listRecid * 8L, 0x328000000000000L | listPhysid);
            } else {
                this.phys.putLong(listPhysid2 + 8L + (long)(8 * numberOfRecordsInPage), offset);
                this.phys.putUnsignedByte(listPhysid2, (byte)(numberOfRecordsInPage + 1));
            }
        }
    }

    @Override
    protected long freePhysRecTake(int requiredSize) throws IOException {
        long freePhysRec;
        this.writeLock_checkLocked();
        if (requiredSize <= 0) {
            throw new InternalError();
        }
        long l = freePhysRec = this.appendOnly ? 0L : this.findFreePhysSlot(requiredSize);
        if (freePhysRec != 0L) {
            return freePhysRec;
        }
        long physFileSize = this.index.getLong(8L);
        if (physFileSize <= 0L) {
            throw new InternalError("illegal file size:" + physFileSize);
        }
        if (physFileSize % 0x40000000L + (long)requiredSize <= 0x40000000L) {
            this.phys.ensureAvailable(physFileSize + (long)requiredSize);
            this.index.putLong(8L, physFileSize + (long)requiredSize);
            return (long)requiredSize << 48 | physFileSize;
        }
        long freeSizeToCreate = 0x40000000L - physFileSize % 0x40000000L;
        if (freeSizeToCreate == 0L) {
            throw new InternalError();
        }
        long nextBufferStartOffset = physFileSize + freeSizeToCreate;
        if (nextBufferStartOffset % 0x40000000L != 0L) {
            throw new InternalError();
        }
        this.phys.ensureAvailable(physFileSize + freeSizeToCreate + (long)requiredSize);
        this.index.putLong(8L, physFileSize + freeSizeToCreate + (long)requiredSize);
        this.freePhysRecPut(freeSizeToCreate << 48 | physFileSize);
        return (long)requiredSize << 48 | nextBufferStartOffset;
    }
}

