/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.mapdb.Atomic;
import org.mapdb.Engine;
import org.mapdb.Locks;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public abstract class Queue2<E>
implements Queue<E> {
    protected final Engine engine;
    protected final Serializer<E> serializer;
    protected final Atomic.Long head;
    protected final Serializer<Node<E>> nodeSerializer = new Serializer<Node<E>>(){

        @Override
        public void serialize(DataOutput out, Node<E> value) throws IOException {
            if (value == null) {
                return;
            }
            Utils.packLong(out, value.next);
            Queue2.this.serializer.serialize(out, value.value);
        }

        @Override
        public Node<E> deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return new Node(Utils.unpackLong(in), Queue2.this.serializer.deserialize(in, -1));
        }
    };

    public Queue2(Engine engine, Serializer<E> serializer, long headRecid) {
        this.engine = engine;
        this.serializer = serializer;
        if (headRecid == 0L) {
            headRecid = engine.put(0L, Serializer.LONG_SERIALIZER);
        }
        this.head = new Atomic.Long(engine, headRecid);
    }

    public void close() {
        this.engine.close();
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove();
        }
    }

    @Override
    public E remove() {
        Object ret = this.poll();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public E element() {
        Object ret = this.peek();
        if (ret == null) {
            throw new NoSuchElementException();
        }
        return ret;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean isEmpty() {
        return this.head.get() == 0L;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public static class Fifo<E>
    extends Queue2<E> {
        protected final Atomic.Long tail;

        public Fifo(Engine engine, Serializer<E> serializer, long headerRecid) {
            super(engine, serializer, headerRecid);
            long nextTail = engine.put(null, this.nodeSerializer);
            long recid = engine.put(nextTail, Serializer.LONG_SERIALIZER);
            this.tail = new Atomic.Long(engine, recid);
        }

        @Override
        public boolean isEmpty() {
            return this.head.get() == 0L;
        }

        @Override
        public boolean add(E item) {
            long nextTail = this.engine.put(null, this.nodeSerializer);
            Node<E> n = new Node<E>(nextTail, item);
            long tail2 = this.tail.get();
            while (!this.engine.compareAndSwap(tail2, null, n, this.nodeSerializer)) {
                tail2 = this.tail.get();
            }
            this.head.compareAndSet(0L, tail2);
            this.tail.set(nextTail);
            return true;
        }

        @Override
        public E poll() {
            long head2;
            Node n;
            do {
                if ((head2 = this.head.get()) != 0L) continue;
                return null;
            } while ((n = (Node)this.engine.get(head2, this.nodeSerializer)) == null || !this.engine.compareAndSwap(head2, n, null, this.nodeSerializer));
            if (!this.head.compareAndSet(head2, n.next)) {
                throw new InternalError();
            }
            return n.value;
        }

        @Override
        public E peek() {
            long head2 = this.head.get();
            if (head2 == 0L) {
                return null;
            }
            Node n = (Node)this.engine.get(head2, this.nodeSerializer);
            while (n == null) {
                n = (Node)this.engine.get(head2, this.nodeSerializer);
            }
            return n.value;
        }
    }

    public static class Lifo<E>
    extends Queue2<E> {
        protected final boolean useLocks;
        protected final Locks.RecidLocks locks;

        public Lifo(Engine engine, Serializer<E> serializer, long headerRecid, boolean useLocks) {
            super(engine, serializer, headerRecid);
            this.useLocks = useLocks;
            this.locks = useLocks ? new Locks.LongHashMapRecidLocks() : null;
        }

        @Override
        public E peek() {
            Node n;
            long head3;
            long head2;
            do {
                if (0L == (head2 = this.head.get())) {
                    return null;
                }
                n = (Node)this.engine.get(head2, this.nodeSerializer);
                head3 = this.head.get();
                if (0L != head2) continue;
                return null;
            } while (head2 != head3);
            return n.value;
        }

        @Override
        public E poll() {
            Node n;
            long head2 = 0L;
            do {
                if (this.useLocks && head2 != 0L) {
                    this.locks.unlock(head2);
                }
                if ((head2 = this.head.get()) == 0L) {
                    return null;
                }
                if (!this.useLocks || head2 == 0L) continue;
                this.locks.lock(head2);
            } while ((n = (Node)this.engine.get(head2, this.nodeSerializer)) == null || !this.head.compareAndSet(head2, n.next));
            if (this.useLocks && head2 != 0L) {
                this.engine.delete(head2);
                this.locks.unlock(head2);
            } else {
                this.engine.update(head2, null, this.nodeSerializer);
            }
            return n.value;
        }

        @Override
        public boolean add(E e) {
            long head2 = this.head.get();
            Node<E> n = new Node<E>(head2, e);
            long recid = this.engine.put(n, this.nodeSerializer);
            while (!this.head.compareAndSet(head2, recid)) {
                head2 = this.head.get();
                n = new Node<E>(head2, e);
                this.engine.update(recid, n, this.nodeSerializer);
            }
            return true;
        }
    }

    protected static final class Node<E> {
        protected final long next;
        protected final E value;

        public Node(long next, E value) {
            this.next = next;
            this.value = value;
        }
    }
}

