/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreArchive;
import org.mapdb.Volume;

public final class Pump {
    private static final Logger LOG = Logger.getLogger(Pump.class.getName());
    private static Method parallelSortMethod;

    public static <E> Iterator<E> sort(Iterator<E> source, boolean mergeDuplicates, int batchSize, Comparator comparator, final Serializer<E> serializer, Executor executor) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (comparator == null) {
            comparator = Fun.comparator();
        }
        if (source == null) {
            source = Fun.emptyIterator();
        }
        int counter = 0;
        Object[] presort = new Object[batchSize];
        final ArrayList<Object> presortFiles = new ArrayList<Object>();
        ArrayList<Integer> presortCount2 = new ArrayList<Integer>();
        try {
            Object f;
            while (source.hasNext()) {
                presort[counter] = source.next();
                if (++counter < batchSize) continue;
                Pump.arraySort(presort, presort.length, comparator, executor);
                f = File.createTempFile("mapdb", "sort");
                ((File)f).deleteOnExit();
                presortFiles.add(f);
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)f)));
                for (Object e : presort) {
                    serializer.serialize(out, e);
                }
                out.close();
                presortCount2.add(counter);
                Arrays.fill(presort, (Object)0);
                counter = 0;
            }
            if (presortFiles.isEmpty()) {
                Pump.arraySort(presort, counter, comparator, executor);
                f = Pump.arrayIterator(presort, 0, counter);
                return f;
            }
            final int[] presortCount = new int[presortFiles.size()];
            for (int i = 0; i < presortCount.length; ++i) {
                presortCount[i] = (Integer)presortCount2.get(i);
            }
            Iterator[] iterators = new Iterator[presortFiles.size() + 1];
            final DataInputStream[] ins = new DataInputStream[presortFiles.size()];
            for (int i = 0; i < presortFiles.size(); ++i) {
                ins[i] = new DataInputStream(new BufferedInputStream(new FileInputStream((File)presortFiles.get(i))));
                final int pos = i;
                iterators[i] = new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return presortCount[pos] > 0;
                    }

                    public Object next() {
                        try {
                            Object ret = serializer.deserialize(ins[pos], -1);
                            int n = pos;
                            presortCount[n] = presortCount[n] - 1;
                            if (presortCount[n] == 0) {
                                ins[pos].close();
                                ((File)presortFiles.get(pos)).delete();
                            }
                            return ret;
                        }
                        catch (IOException e) {
                            throw new IOError(e);
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            Pump.arraySort(presort, counter, comparator, executor);
            iterators[iterators.length - 1] = Pump.arrayIterator(presort, 0, counter);
            Iterator iterator = Pump.sort(comparator, mergeDuplicates, iterators);
            return iterator;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            for (File file : presortFiles) {
                file.delete();
            }
        }
    }

    protected static void arraySort(Object[] array, int arrayLen, Comparator comparator, Executor executor) {
        if (executor != null && parallelSortMethod != null) {
            try {
                parallelSortMethod.invoke(null, array, 0, arrayLen, comparator);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Arrays.sort(array, 0, arrayLen, comparator);
    }

    public static <E> Iterator<E> sort(Comparator<E> comparator, final boolean mergeDuplicates, final Iterator<E> ... iterators) {
        final Comparator<E> comparator2 = comparator == null ? Fun.COMPARATOR : comparator;
        return new Iterator<E>(){
            final NavigableSet<Object[]> items;
            Object next;
            {
                this.items = new TreeSet<Object[]>(new Fun.ArrayComparator(comparator2, Fun.COMPARATOR));
                this.next = this;
                for (int i = 0; i < iterators.length; ++i) {
                    if (!iterators[i].hasNext()) continue;
                    this.items.add(new Object[]{iterators[i].next(), i});
                }
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object oldNext = this.next;
                Object[] lo = this.items.pollFirst();
                if (lo == null) {
                    this.next = null;
                    return oldNext;
                }
                this.next = lo[0];
                if (oldNext != this && comparator2.compare(oldNext, this.next) > 0) {
                    throw new IllegalArgumentException("One of the iterators is not sorted");
                }
                Iterator iter = iterators[(Integer)lo[1]];
                if (iter.hasNext()) {
                    this.items.add(new Object[]{iter.next(), lo[1]});
                }
                if (mergeDuplicates) {
                    Iterator<Object[]> subset;
                    while ((subset = Fun.filter(this.items, this.next).iterator()).hasNext()) {
                        LinkedList<Object[]> subset2 = new LinkedList<Object[]>();
                        while (subset.hasNext()) {
                            subset2.add(subset.next());
                        }
                        ArrayList<Object[]> toadd = new ArrayList<Object[]>();
                        for (Object[] t : subset2) {
                            this.items.remove(t);
                            iter = iterators[(Integer)t[1]];
                            if (!iter.hasNext()) continue;
                            toadd.add(new Object[]{iter.next(), t[1]});
                        }
                        this.items.addAll(toadd);
                    }
                }
                return oldNext;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterator<E> merge(Executor executor, final Iterator ... iters) {
        if (iters.length == 0) {
            return Fun.emptyIterator();
        }
        final Iterator ret = new Iterator<E>(){
            int i = 0;
            Object next = this;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                while (!iters[this.i].hasNext()) {
                    ++this.i;
                    if (this.i != iters.length) continue;
                    Object ret = this.next;
                    this.next = null;
                    return ret;
                }
                Object ret = this.next;
                this.next = iters[this.i].next();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (executor == null) {
            return ret;
        }
        final Object poisonPill = new Object();
        final ArrayBlockingQueue q = new ArrayBlockingQueue(128);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        while (ret.hasNext()) {
                            q.put(ret.next());
                        }
                    }
                    finally {
                        q.put(poisonPill);
                    }
                }
                catch (InterruptedException e) {
                    LOG.log(Level.SEVERE, "feeder failed", e);
                }
            }
        });
        return Pump.poisonPillIterator(q, poisonPill);
    }

    public static <E> Iterator<E> poisonPillIterator(final BlockingQueue<E> q, final Object poisonPill) {
        return new Iterator<E>(){
            E next = this.getNext();

            private E getNext() {
                try {
                    Object ret = q.take();
                    if (ret == poisonPill) {
                        return null;
                    }
                    return ret;
                }
                catch (InterruptedException e) {
                    throw new DBException.Interrupted(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                Object ret = this.next;
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.getNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E, K, V> long buildTreeMap(Iterator<E> source, Engine engine, Fun.Function1<K, E> keyExtractor, Fun.Function1<V, E> valueExtractor, boolean ignoreDuplicates, int nodeSize, boolean valuesStoredOutsideNodes, long counterRecid, BTreeKeySerializer keySerializer, Serializer<V> valueSerializer, Executor executor) {
        Serializer<Object> valueNodeSerializer;
        if (keyExtractor == null) {
            keyExtractor = Fun.extractNoTransform();
        }
        if (valueSerializer == null) {
            valueSerializer = BTreeMap.BOOLEAN_PACKED;
            if (valueExtractor != null) {
                throw new IllegalArgumentException();
            }
            valueExtractor = new Fun.Function1(){

                public Object run(Object e) {
                    return Boolean.TRUE;
                }
            };
        }
        Serializer<Object> serializer = valueNodeSerializer = valuesStoredOutsideNodes ? BTreeMap.VALREF_SERIALIZER : valueSerializer;
        if (ignoreDuplicates) {
            source = Pump.ignoreDuplicatesIterator(source, keySerializer.comparator(), keyExtractor);
        }
        source = Pump.checkSortedIterator(source, keySerializer.comparator(), keyExtractor);
        double NODE_LOAD = 0.75;
        int maxNodeSize = (int)((double)nodeSize * 0.75);
        BTreeMap.NodeSerializer nodeSerializer = new BTreeMap.NodeSerializer(valuesStoredOutsideNodes, keySerializer, valueNodeSerializer, 0);
        ArrayList dirKeys = new ArrayList();
        dirKeys.add(new ArrayList());
        ArrayList<ArrayList<Long>> dirRecids = new ArrayList<ArrayList<Long>>();
        dirRecids.add(Pump.arrayList(0L));
        ArrayList<K> leafKeys = new ArrayList<K>();
        ArrayList leafValues = new ArrayList();
        long counter = 0L;
        long rootRecid = 0L;
        long lastLeafRecid = 0L;
        block0: while (source.hasNext()) {
            E iterNext = source.next();
            boolean isLeftMost = !source.hasNext();
            ++counter;
            K key = keyExtractor.run(iterNext);
            Object value = valueExtractor.run(iterNext);
            if (valuesStoredOutsideNodes) {
                long recid = engine.put(value, valueSerializer);
                value = new BTreeMap.ValRef(recid);
            }
            leafKeys.add(key);
            if (!isLeftMost && leafKeys.size() <= maxNodeSize) {
                leafValues.add(value);
                continue;
            }
            if (isLeftMost) {
                leafValues.add(value);
            }
            Collections.reverse(leafKeys);
            Collections.reverse(leafValues);
            BTreeMap.LeafNode leaf = new BTreeMap.LeafNode(keySerializer.arrayToKeys(leafKeys.toArray()), isLeftMost, lastLeafRecid == 0L, false, valueNodeSerializer.valueArrayFromArray(leafValues.toArray()), lastLeafRecid);
            lastLeafRecid = engine.put(leaf, nodeSerializer);
            if (isLeftMost && ((ArrayList)dirKeys.get(0)).size() == 0) {
                rootRecid = lastLeafRecid;
                break;
            }
            Object leafLink = leafKeys.get(0);
            ((ArrayList)dirKeys.get(0)).add(leafLink);
            ((ArrayList)dirRecids.get(0)).add(lastLeafRecid);
            leafKeys.clear();
            leafValues.clear();
            if (!isLeftMost) {
                leafKeys.add(key);
                leafKeys.add(key);
                leafValues.add(value);
            }
            for (int level = 0; level < dirKeys.size(); ++level) {
                ArrayList keys = (ArrayList)dirKeys.get(level);
                if (!isLeftMost && keys.size() <= maxNodeSize) continue block0;
                if (isLeftMost) {
                    keys.remove(keys.size() - 1);
                }
                Collections.reverse(keys);
                List recids = (List)dirRecids.get(level);
                Collections.reverse(recids);
                boolean isRightMost = level + 1 == dirKeys.size();
                BTreeMap.DirNode dir = new BTreeMap.DirNode(keySerializer.arrayToKeys(keys.toArray()), isLeftMost, isRightMost, false, Pump.toLongArray(recids));
                long dirRecid = engine.put(dir, nodeSerializer);
                if (isLeftMost && isRightMost) {
                    rootRecid = dirRecid;
                    break block0;
                }
                Object linkKey = keys.get(0);
                keys.clear();
                recids.clear();
                keys.add(linkKey);
                recids.add(dirRecid);
                if (dirKeys.size() == level + 1) {
                    dirKeys.add(new ArrayList());
                    dirRecids.add(Pump.arrayList(0L));
                }
                ((ArrayList)dirKeys.get(level + 1)).add(linkKey);
                ((ArrayList)dirRecids.get(level + 1)).add(dirRecid);
            }
        }
        if (rootRecid == 0L) {
            BTreeMap.LeafNode emptyRoot = new BTreeMap.LeafNode(keySerializer.emptyKeys(), true, true, false, valueNodeSerializer.valueArrayEmpty(), 0L);
            rootRecid = engine.put(emptyRoot, nodeSerializer);
        }
        if (counterRecid != 0L) {
            engine.update(counterRecid, counter, Serializer.LONG);
        }
        return engine.put(rootRecid, Serializer.RECID);
    }

    private static <E, K> Iterator<E> checkSortedIterator(final Iterator<E> source, final Comparator comparator, final Fun.Function1<K, E> keyExtractor) {
        return new Iterator<E>(){
            E next;
            {
                this.next = source.hasNext() ? source.next() : null;
            }

            E advance() {
                if (!source.hasNext()) {
                    return null;
                }
                Object ret = source.next();
                int compare = comparator.compare(keyExtractor.run(ret), keyExtractor.run(this.next));
                if (compare == 0) {
                    throw new DBException.PumpSourceDuplicate(this.next);
                }
                if (compare > 0) {
                    throw new DBException.PumpSourceNotSorted();
                }
                return ret;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = this.advance();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <E, K> Iterator<E> ignoreDuplicatesIterator(final Iterator<E> source, final Comparator<K> comparator, final Fun.Function1<K, E> keyExtractor) {
        return new Iterator<E>(){
            E next;
            {
                this.next = source.hasNext() ? source.next() : null;
            }

            E advance() {
                while (source.hasNext()) {
                    Object n = source.next();
                    if (comparator.compare(keyExtractor.run(n), keyExtractor.run(this.next)) == 0) continue;
                    return n;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = this.advance();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Object toLongArray(List<Long> child) {
        Object[] ret;
        boolean allInts = true;
        for (Long l : child) {
            if (l <= Integer.MAX_VALUE) continue;
            allInts = false;
            break;
        }
        if (allInts) {
            ret = new int[child.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = child.get(i).intValue();
            }
            return ret;
        }
        ret = new long[child.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)child.get(i).longValue();
        }
        return ret;
    }

    private static <E> ArrayList<E> arrayList(E item) {
        ArrayList<E> ret = new ArrayList<E>();
        ret.add(item);
        return ret;
    }

    private static <E> Iterator<E> arrayIterator(final Object[] array, final int fromIndex, final int toIndex) {
        return new Iterator<E>(){
            int index;
            {
                this.index = fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < toIndex;
            }

            @Override
            public E next() {
                if (this.index >= toIndex) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <K, V, A> void fillHTreeMap(final HTreeMap<K, V> m, Iterator<A> pumpSource, final Fun.Function1<K, A> pumpKeyExtractor, Fun.Function1<V, A> pumpValueExtractor, int pumpPresortBatchSize, boolean pumpIgnoreDuplicates, Serializer<A> sortSerializer, Executor executor) {
        Comparator hashComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int h2;
                o1 = pumpKeyExtractor.run(o1);
                o2 = pumpKeyExtractor.run(o2);
                int h1 = m.hash(o1);
                if (h1 < (h2 = m.hash(o2))) {
                    return -1;
                }
                if (h1 == h2) {
                    return 0;
                }
                return 1;
            }
        };
        pumpSource = Pump.sort(pumpSource, false, pumpPresortBatchSize, hashComparator, sortSerializer, executor);
        while (pumpSource.hasNext()) {
            Boolean val;
            A o = pumpSource.next();
            K key = pumpKeyExtractor.run(o);
            Boolean bl = val = pumpValueExtractor == null ? Boolean.TRUE : pumpValueExtractor.run(o);
            if (pumpIgnoreDuplicates) {
                m.put(key, val);
                continue;
            }
            Boolean old = m.putIfAbsent(key, val);
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate at: " + o.toString());
        }
    }

    public static void copy(DB src, DB target) {
    }

    public static void backupFull(DB db, OutputStream out) {
        Store store = Store.forDB(db);
        store.backup(out, false);
    }

    public static DB backupFullRestore(DBMaker.Maker maker, InputStream in) {
        DB db = maker.make();
        Store store = Store.forDB(db);
        store.backupRestore(new InputStream[]{in});
        return db;
    }

    public static void backupIncremental(DB db, File backupDir) {
        try {
            File[] files = backupDir.listFiles();
            boolean isEmpty = files.length == 0;
            long timestamp = System.currentTimeMillis();
            long lastTimestamp = 0L;
            for (File f : files) {
                String num = Pump.nameWithoutExt(f);
                long fTimestamp = Long.valueOf(num);
                timestamp = Math.max(fTimestamp + 1L, timestamp);
                lastTimestamp = Math.max(lastTimestamp, fTimestamp);
            }
            File file = new File(backupDir, "" + timestamp + (isEmpty ? ".full" : ".inc"));
            FileOutputStream out = new FileOutputStream(file);
            Store store = Store.forDB(db);
            DataOutputStream out2 = new DataOutputStream(out);
            out2.writeInt(-1445265308);
            out2.writeInt(0);
            out2.writeLong(store.makeFeaturesBitmap());
            out2.writeLong(0L);
            out2.writeLong(timestamp);
            out2.writeLong(lastTimestamp);
            store.backup(out, true);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    public static DB backupIncrementalRestore(DBMaker.Maker maker, File backupDir) {
        try {
            File[] files = backupDir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long n1 = Long.valueOf(Pump.nameWithoutExt(o1));
                    long n2 = Long.valueOf(Pump.nameWithoutExt(o2));
                    return Fun.compareLong(n1, n2);
                }
            });
            InputStream[] ins = new InputStream[files.length];
            for (int i = 0; i < ins.length; ++i) {
                ins[i] = new FileInputStream(files[i]);
                ins[i].skip(40L);
            }
            DB db = maker.make();
            Store store = Store.forDB(db);
            store.backupRestore(ins);
            return db;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    protected static String nameWithoutExt(File f) {
        String num = f.getName();
        num = num.substring(0, num.indexOf(46));
        return num;
    }

    public static void archiveTreeMap(NavigableMap source, File target, DB.BTreeMapMaker config) {
        StoreArchive s = new StoreArchive(target.getPath(), Volume.RandomAccessFileVol.FACTORY, false);
        s.init();
        long counterRecid = config.counter ? s.put(0L, Serializer.LONG) : 0L;
        long rootRecid = Pump.buildTreeMap(source.descendingMap().entrySet().iterator(), s, Fun.extractMapEntryKey(), Fun.extractMapEntryValue(), false, config.nodeSize, config.valuesOutsideNodes, counterRecid, config.getKeySerializer(), config.valueSerializer, null);
        String name = config.name;
        TreeMap<String, Object> c = new TreeMap<String, Object>();
        c.put(name + ".type", "TreeMap");
        c.put(name + ".rootRecidRef", rootRecid);
        c.put(name + ".maxNodeSize", config.nodeSize);
        c.put(name + ".valuesOutsideNodes", config.valuesOutsideNodes);
        c.put(name + ".counterRecids", counterRecid);
        c.put(name + ".keySerializer", config.getKeySerializer());
        c.put(name + ".valueSerializer", config.valueSerializer);
        c.put(name + ".numberOfNodeMetas", 0);
        s.rewriteNamedCatalog(c);
        s.close();
    }

    public static void archiveTreeMap(Iterator<Fun.Pair> source, String file, Volume.VolumeFactory factory, DB.BTreeMapMaker config) {
        StoreArchive s = new StoreArchive(file, factory, false);
        s.init();
        long counterRecid = config.counter ? s.put(0L, Serializer.LONG) : 0L;
        long rootRecid = Pump.buildTreeMap(source, s, Fun.extractKey(), Fun.extractValue(), false, config.nodeSize, config.valuesOutsideNodes, counterRecid, config.getKeySerializer(), config.valueSerializer, null);
        String name = config.name;
        TreeMap<String, Object> c = new TreeMap<String, Object>();
        c.put(name + ".type", "TreeMap");
        c.put(name + ".rootRecidRef", rootRecid);
        c.put(name + ".maxNodeSize", config.nodeSize);
        c.put(name + ".valuesOutsideNodes", config.valuesOutsideNodes);
        c.put(name + ".counterRecids", counterRecid);
        c.put(name + ".keySerializer", config.getKeySerializer());
        c.put(name + ".valueSerializer", config.valueSerializer);
        c.put(name + ".numberOfNodeMetas", 0);
        s.rewriteNamedCatalog(c);
        s.close();
    }

    static {
        try {
            parallelSortMethod = Arrays.class.getMethod("parallelSort", Object[].class, Integer.TYPE, Integer.TYPE, Comparator.class);
        }
        catch (NoSuchMethodException e) {
            parallelSortMethod = null;
        }
    }
}

