/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.LongConcurrentHashMap;

public final class Locks {
    private Locks() {
    }

    public static class SegmentedRecidLocks
    implements RecidLocks {
        protected final ReentrantLock[] locks;
        protected final int numSegments;

        public SegmentedRecidLocks(int numSegments) {
            this.numSegments = numSegments;
            this.locks = new ReentrantLock[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                this.locks[i] = new ReentrantLock();
            }
        }

        @Override
        public void unlock(long recid) {
            this.locks[(int)(recid % (long)this.numSegments)].unlock();
        }

        @Override
        public void assertNoLocks() {
            for (ReentrantLock l : this.locks) {
                if (!l.isLocked()) continue;
                throw new InternalError("Some node is still locked by current thread");
            }
        }

        @Override
        public void lock(long recid) {
            this.locks[(int)(recid % (long)this.numSegments)].lock();
        }
    }

    public static class LongHashMapRecidLocks
    implements RecidLocks {
        protected final LongConcurrentHashMap<Thread> locks = new LongConcurrentHashMap();

        @Override
        public void unlock(long recid) {
            Thread t = this.locks.remove(recid);
            if (t != Thread.currentThread()) {
                throw new InternalError("unlocked wrong thread");
            }
        }

        @Override
        public void assertNoLocks() {
        }

        @Override
        public void lock(long recid) {
            if (this.locks.get(recid) == Thread.currentThread()) {
                throw new InternalError("node already locked by current thread: " + recid);
            }
            while (this.locks.putIfAbsent(recid, Thread.currentThread()) != null) {
                Thread.yield();
            }
        }
    }

    public static interface RecidLocks {
        public void unlock(long var1);

        public void assertNoLocks();

        public void lock(long var1);
    }
}

